/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.internal;

import io.restassured.authentication.AuthenticationScheme;
import io.restassured.authentication.NoAuthScheme;
import io.restassured.filter.log.LogDetail;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.internal.LogSpecificationImpl;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.module.webtestclient.internal.WebTestClientRequestSpecificationImpl;
import io.restassured.module.webtestclient.specification.WebTestClientRequestLogSpecification;
import io.restassured.module.webtestclient.specification.WebTestClientRequestSpecification;
import io.restassured.specification.RequestSpecification;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;

public class WebTestClientRequestLogSpecificationImpl
extends LogSpecificationImpl
implements WebTestClientRequestLogSpecification {
    private final WebTestClientRequestSpecificationImpl requestSpecification;

    public WebTestClientRequestLogSpecificationImpl(WebTestClientRequestSpecificationImpl requestSpecification) {
        this.requestSpecification = requestSpecification;
    }

    public WebTestClientRequestSpecification body() {
        return this.body(this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public WebTestClientRequestSpecification body(boolean shouldPrettyPrint) {
        return this.logWith(LogDetail.BODY, shouldPrettyPrint);
    }

    public WebTestClientRequestSpecification all() {
        return this.all(this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public WebTestClientRequestSpecification all(boolean shouldPrettyPrint) {
        return this.logWith(LogDetail.ALL, shouldPrettyPrint);
    }

    public WebTestClientRequestSpecification everything() {
        return this.all();
    }

    public WebTestClientRequestSpecification everything(boolean shouldPrettyPrint) {
        return this.all(shouldPrettyPrint);
    }

    public WebTestClientRequestSpecification headers() {
        return this.logWith(LogDetail.HEADERS);
    }

    public WebTestClientRequestSpecification cookies() {
        return this.logWith(LogDetail.COOKIES);
    }

    public WebTestClientRequestSpecification ifValidationFails() {
        return this.ifValidationFails(LogDetail.ALL);
    }

    public WebTestClientRequestSpecification ifValidationFails(LogDetail logDetail) {
        return this.ifValidationFails(logDetail, this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public WebTestClientRequestSpecification ifValidationFails(LogDetail logDetail, boolean shouldPrettyPrint) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.requestSpecification.getLogRepository().registerRequestLog(byteArrayOutputStream);
        return this.logWith(logDetail, shouldPrettyPrint, printStream);
    }

    @Override
    public WebTestClientRequestSpecification params() {
        return this.logWith(LogDetail.PARAMS);
    }

    private WebTestClientRequestSpecification logWith(LogDetail logDetail, boolean prettyPrintingEnabled, PrintStream printStream) {
        boolean shouldUrlEncodeRequestUri = this.requestSpecification.getRestAssuredWebTestClientConfig().getLogConfig().shouldUrlEncodeRequestUri();
        this.requestSpecification.setRequestLoggingFilter(new RequestLoggingFilter(logDetail, prettyPrintingEnabled, printStream, shouldUrlEncodeRequestUri));
        return this.requestSpecification;
    }

    private WebTestClientRequestSpecification logWith(LogDetail logDetail) {
        RequestSpecificationImpl reqSpec = this.toRequestSpecification();
        return this.logWith(logDetail, this.shouldPrettyPrint((RequestSpecification)reqSpec));
    }

    private RequestSpecificationImpl toRequestSpecification() {
        return new RequestSpecificationImpl("", 8080, "", (AuthenticationScheme)new NoAuthScheme(), Collections.emptyList(), null, true, this.requestSpecification.getRestAssuredConfig(), this.requestSpecification.getLogRepository(), null);
    }

    private WebTestClientRequestSpecification logWith(LogDetail logDetail, boolean prettyPrintingEnabled) {
        return this.logWith(logDetail, prettyPrintingEnabled, this.getPrintStream((RequestSpecification)this.toRequestSpecification()));
    }
}

