/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.specification;

import io.restassured.config.LogConfig;
import io.restassured.filter.log.LogDetail;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.http.ContentType;
import io.restassured.http.Cookie;
import io.restassured.http.Header;
import io.restassured.internal.assertion.AssertParameter;
import io.restassured.mapper.ObjectMapper;
import io.restassured.mapper.ObjectMapperType;
import io.restassured.module.mockmvc.RestAssuredMockMvc;
import io.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import io.restassured.module.mockmvc.intercept.MockHttpServletRequestBuilderInterceptor;
import io.restassured.module.mockmvc.internal.MockMvcFactory;
import io.restassured.module.mockmvc.internal.MockMvcRequestSpecificationImpl;
import io.restassured.module.mockmvc.specification.MockMvcAuthenticationScheme;
import io.restassured.module.mockmvc.specification.MockMvcRequestSpecification;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilder;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public class MockMvcRequestSpecBuilder {
    private MockMvcRequestSpecificationImpl spec = (MockMvcRequestSpecificationImpl)new MockMvcRequestSpecificationImpl(MockMvcRequestSpecBuilder.getConfiguredMockMvcFactory(), RestAssuredMockMvc.config, RestAssuredMockMvc.resultHandlers(), RestAssuredMockMvc.postProcessors(), RestAssuredMockMvc.basePath, RestAssuredMockMvc.requestSpecification, RestAssuredMockMvc.responseSpecification, RestAssuredMockMvc.authentication).config(RestAssuredMockMvc.config);

    public MockMvcRequestSpecBuilder setAuth(MockMvcAuthenticationScheme auth) {
        auth.authenticate(this.spec);
        return this;
    }

    public MockMvcRequestSpecBuilder setPostProcessors(RequestPostProcessor postProcessors) {
        this.spec.postProcessors(postProcessors, new RequestPostProcessor[0]);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(String body) {
        this.spec.body(body);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(byte[] body) {
        this.spec.body(body);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(Object object) {
        this.spec.body(object);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(Object object, ObjectMapper mapper) {
        this.spec.body(object, mapper);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(Object object, ObjectMapperType mapperType) {
        this.spec.body(object, mapperType);
        return this;
    }

    MockMvcRequestSpecBuilder addSessionAttrs(Map<String, Object> sessionAttributes) {
        this.spec.sessionAttrs(sessionAttributes);
        return this;
    }

    MockMvcRequestSpecBuilder addSessionAttr(String name, Object value) {
        this.spec.sessionAttr(name, value);
        return this;
    }

    public MockMvcRequestSpecBuilder addCookies(Map<String, ?> cookies) {
        this.spec.cookies(cookies);
        return this;
    }

    public MockMvcRequestSpecBuilder addCookie(Cookie cookie) {
        this.spec.cookie(cookie);
        return this;
    }

    public MockMvcRequestSpecBuilder addCookie(String key, Object value, Object ... cookieNameValuePairs) {
        this.spec.cookie(key, value, cookieNameValuePairs);
        return this;
    }

    public MockMvcRequestSpecBuilder addParams(Map<String, ?> parametersMap) {
        this.spec.params(parametersMap);
        return this;
    }

    public MockMvcRequestSpecBuilder addParam(String parameterName, Object ... parameterValues) {
        this.spec.param(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addParam(String parameterName, Collection<?> parameterValues) {
        this.spec.param(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addQueryParam(String parameterName, Collection<?> parameterValues) {
        this.spec.queryParam(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addQueryParams(Map<String, ?> parametersMap) {
        this.spec.queryParams(parametersMap);
        return this;
    }

    public MockMvcRequestSpecBuilder addQueryParam(String parameterName, Object ... parameterValues) {
        this.spec.queryParam(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addFormParam(String parameterName, Collection<?> parameterValues) {
        this.spec.formParam(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addFormParams(Map<String, ?> parametersMap) {
        this.spec.formParams(parametersMap);
        return this;
    }

    public MockMvcRequestSpecBuilder addFormParam(String parameterName, Object ... parameterValues) {
        this.spec.formParam(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addAttribute(String attributeName, Object attributeValue) {
        this.spec.attribute(attributeName, attributeValue);
        return this;
    }

    public MockMvcRequestSpecBuilder addAttributes(Map<String, ?> attributesMap) {
        this.spec.attributes(attributesMap);
        return this;
    }

    public MockMvcRequestSpecBuilder addHeaders(Map<String, String> headers) {
        this.spec.headers(headers);
        return this;
    }

    public MockMvcRequestSpecBuilder addHeader(String headerName, String headerValue) {
        this.spec.header(headerName, headerValue, new Object[0]);
        return this;
    }

    public MockMvcRequestSpecBuilder addHeader(Header header) {
        this.spec.header(header);
        return this;
    }

    public MockMvcRequestSpecBuilder setContentType(ContentType contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public MockMvcRequestSpecBuilder setContentType(String contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(File file) {
        this.spec.multiPart(file);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, File file) {
        this.spec.multiPart(controlName, file);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, File file, String mimeType) {
        this.spec.multiPart(controlName, file, mimeType);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String fileName, byte[] bytes) {
        this.spec.multiPart(controlName, fileName, bytes);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String fileName, byte[] bytes, String mimeType) {
        this.spec.multiPart(controlName, fileName, bytes, mimeType);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String fileName, InputStream stream) {
        this.spec.multiPart(controlName, fileName, stream);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String fileName, InputStream stream, String mimeType) {
        this.spec.multiPart(controlName, fileName, stream, mimeType);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String contentBody) {
        this.spec.multiPart(controlName, contentBody);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String contentBody, String mimeType) {
        this.spec.multiPart(controlName, mimeType);
        return this;
    }

    public MockMvcRequestSpecBuilder setSessionId(String sessionIdValue) {
        this.spec.sessionId(sessionIdValue);
        return this;
    }

    public MockMvcRequestSpecBuilder setSessionId(String sessionIdName, String sessionIdValue) {
        this.spec.sessionId(sessionIdName, sessionIdValue);
        return this;
    }

    public MockMvcRequestSpecBuilder addMockMvcRequestSpecification(MockMvcRequestSpecification specification) {
        this.spec.spec(specification);
        return this;
    }

    public MockMvcRequestSpecBuilder setConfig(RestAssuredMockMvcConfig config) {
        this.spec.config(config);
        return this;
    }

    public MockMvcRequestSpecification build() {
        return this.spec;
    }

    public MockMvcRequestSpecBuilder setBasePath(String basePath) {
        this.spec.basePath(basePath);
        return this;
    }

    public MockMvcRequestSpecBuilder setMockMvc(MockMvc mockMvc) {
        this.spec.mockMvc(mockMvc);
        return this;
    }

    public MockMvcRequestSpecBuilder setStandaloneSetup(Object ... controllers) {
        this.spec.standaloneSetup(controllers);
        return this;
    }

    public MockMvcRequestSpecBuilder setStandaloneSetup(MockMvcBuilder builder) {
        this.spec.standaloneSetup(builder);
        return this;
    }

    public MockMvcRequestSpecBuilder setWebAppContextSetup(WebApplicationContext context, MockMvcConfigurer ... mockMvcConfigurers) {
        this.spec.webAppContextSetup(context, mockMvcConfigurers);
        return this;
    }

    public MockMvcRequestSpecBuilder setMockHttpServletRequestBuilderInterceptor(MockHttpServletRequestBuilderInterceptor interceptor) {
        this.spec.interceptor(interceptor);
        return this;
    }

    public MockMvcRequestSpecBuilder addResultHandlers(ResultHandler resultHandler, ResultHandler ... additionalResultHandlers) {
        this.spec.resultHandlers(resultHandler, additionalResultHandlers);
        return this;
    }

    public MockMvcRequestSpecBuilder log(LogDetail logDetail) {
        AssertParameter.notNull((Object)logDetail, LogDetail.class);
        LogConfig logConfig = this.spec.getRestAssuredMockMvcConfig().getLogConfig();
        PrintStream printStream = logConfig.defaultStream();
        boolean prettyPrintingEnabled = logConfig.isPrettyPrintingEnabled();
        boolean shouldUrlEncodeRequestUri = logConfig.shouldUrlEncodeRequestUri();
        this.spec.setRequestLoggingFilter(new RequestLoggingFilter(logDetail, prettyPrintingEnabled, printStream, shouldUrlEncodeRequestUri));
        return this;
    }

    public MockMvcRequestSpecBuilder and() {
        return this;
    }

    private static MockMvcFactory getConfiguredMockMvcFactory() {
        try {
            Field mockMvcFactory = RestAssuredMockMvc.class.getDeclaredField("mockMvcFactory");
            mockMvcFactory.setAccessible(true);
            Object instance = mockMvcFactory.get(RestAssuredMockMvc.class);
            mockMvcFactory.setAccessible(false);
            return (MockMvcFactory)instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: Cannot find mockMvcFactory field in " + RestAssuredMockMvc.class.getName());
        }
    }
}

