/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.internal;

import io.restassured.config.ParamConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.module.mockmvc.config.MockMvcParamConfig;
import io.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import io.restassured.module.mockmvc.internal.UpdateStrategyConverter;
import java.lang.reflect.Field;

class ConfigConverter {
    ConfigConverter() {
    }

    public static RestAssuredConfig convertToRestAssuredConfig(RestAssuredMockMvcConfig mvcConfig) {
        return new RestAssuredConfig().jsonConfig(mvcConfig.getJsonConfig()).xmlConfig(mvcConfig.getXmlConfig()).sessionConfig(mvcConfig.getSessionConfig()).objectMapperConfig(mvcConfig.getObjectMapperConfig()).logConfig(mvcConfig.getLogConfig()).encoderConfig(mvcConfig.getEncoderConfig()).decoderConfig(mvcConfig.getDecoderConfig()).multiPartConfig(mvcConfig.getMultiPartConfig()).paramConfig(ConfigConverter.toParamConfig(mvcConfig.getParamConfig()));
    }

    private static ParamConfig toParamConfig(MockMvcParamConfig cfg) {
        ParamConfig config = new ParamConfig(UpdateStrategyConverter.convert(cfg.queryParamsUpdateStrategy()), UpdateStrategyConverter.convert(cfg.formParamsUpdateStrategy()), UpdateStrategyConverter.convert(cfg.requestParamsUpdateStrategy()));
        if (!cfg.isUserConfigured()) {
            Field userConfigured = null;
            try {
                userConfigured = config.getClass().getDeclaredField("userConfigured");
                userConfigured.setAccessible(true);
                userConfigured.set(config, false);
            }
            catch (Exception e) {
                throw new RuntimeException("Internal error in REST Assured, please report an issue!", e);
            }
            finally {
                if (userConfigured != null) {
                    userConfigured.setAccessible(false);
                }
            }
        }
        return config;
    }
}

