/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.internal.path.json;

import groovy.io.LineColumnReader;
import groovy.json.JsonException;
import groovy.json.JsonLexer;
import groovy.json.JsonToken;
import groovy.json.JsonTokenType;
import io.restassured.internal.path.json.Groovy5JsonSlurperWorkarounds;
import io.restassured.path.json.config.JsonPathConfig;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class ConfigurableJsonSlurper {
    private final JsonPathConfig.NumberReturnType numberReturnType;

    private Object getValue(JsonToken token) {
        Object result = token.getValue();
        if (this.numberReturnType.isFloatOrDouble() && result instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)result;
            result = this.numberReturnType == JsonPathConfig.NumberReturnType.DOUBLE || decimal.compareTo(BigDecimal.valueOf(3.4028234663852886E38)) > 0 ? (Number)decimal.doubleValue() : (Number)Float.valueOf(decimal.floatValue());
        } else if (JsonPathConfig.NumberReturnType.BIG_INTEGER.equals((Object)this.numberReturnType) && (result instanceof Integer || result instanceof Long)) {
            result = new BigInteger(result.toString());
        }
        return result;
    }

    public ConfigurableJsonSlurper(JsonPathConfig.NumberReturnType numberReturnType) {
        this.numberReturnType = numberReturnType;
    }

    public Object parseText(String text) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("The JSON input text should neither be null nor empty.");
        }
        return this.parse((Reader)new LineColumnReader((Reader)new StringReader(text)));
    }

    public Object parse(Reader reader) {
        Object content;
        JsonLexer lexer = new JsonLexer(reader);
        JsonToken token = lexer.nextToken();
        if (token == null) {
            return null;
        }
        if (token.getType() == JsonTokenType.OPEN_CURLY) {
            content = this.parseObject(lexer);
        } else if (token.getType() == JsonTokenType.OPEN_BRACKET) {
            content = this.parseArray(lexer);
        } else if (token.getType().ordinal() >= JsonTokenType.NULL.ordinal()) {
            content = this.getValue(token);
        } else {
            throw new JsonException("A JSON payload should start with " + JsonTokenType.OPEN_CURLY.getLabel() + ", " + JsonTokenType.OPEN_BRACKET.getLabel() + " or a primitive value.\nInstead, '" + token.getText() + "' was found on line: " + token.getStartLine() + ", column: " + token.getStartColumn());
        }
        return content;
    }

    private List<Object> parseArray(JsonLexer lexer) {
        List<Object> content;
        block10: {
            JsonToken currentToken;
            content = Groovy5JsonSlurperWorkarounds.newList();
            do {
                if ((currentToken = lexer.nextToken()) == null) {
                    throw new JsonException("Expected a value on line: " + lexer.getReader().getLine() + ", column: " + lexer.getReader().getColumn() + ".\nBut got an unterminated array.");
                }
                if (currentToken.getType() == JsonTokenType.OPEN_CURLY) {
                    content.add(this.parseObject(lexer));
                } else if (currentToken.getType() == JsonTokenType.OPEN_BRACKET) {
                    content.add(this.parseArray(lexer));
                } else if (currentToken.getType().ordinal() >= JsonTokenType.NULL.ordinal()) {
                    content.add(this.getValue(currentToken));
                } else {
                    if (currentToken.getType() == JsonTokenType.CLOSE_BRACKET) {
                        return content;
                    }
                    throw new JsonException("Expected a value, an array, or an object on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\nBut got '" + currentToken.getText() + "' instead.");
                }
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected " + JsonTokenType.CLOSE_BRACKET.getLabel() + " or " + JsonTokenType.COMMA.getLabel() + " on line: " + lexer.getReader().getLine() + ", column: " + lexer.getReader().getColumn() + ".\nBut got an unterminated array.");
                }
                if (currentToken.getType() == JsonTokenType.CLOSE_BRACKET) break block10;
            } while (currentToken.getType() == JsonTokenType.COMMA);
            throw new JsonException("Expected a value or " + JsonTokenType.CLOSE_BRACKET.getLabel() + " on line: " + currentToken.getStartLine() + " column: " + currentToken.getStartColumn() + ".\nBut got '" + currentToken.getText() + "' instead.");
        }
        return content;
    }

    private Map<String, Object> parseObject(JsonLexer lexer) {
        Map<String, Object> content;
        block14: {
            content = Groovy5JsonSlurperWorkarounds.newMap();
            JsonToken previousToken = null;
            JsonToken currentToken = null;
            do {
                if ((currentToken = lexer.nextToken()) == null) {
                    throw new JsonException("Expected a String key on line: " + lexer.getReader().getLine() + ", column: " + lexer.getReader().getColumn() + ".\nBut got an unterminated object.");
                }
                if (currentToken.getType() == JsonTokenType.CLOSE_CURLY) {
                    return content;
                }
                if (currentToken.getType() != JsonTokenType.STRING) {
                    throw new JsonException("Expected " + JsonTokenType.STRING.getLabel() + " key on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\nBut got '" + currentToken.getText() + "' instead.");
                }
                String mapKey = (String)currentToken.getValue();
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected a " + JsonTokenType.COLON.getLabel() + " on line: " + lexer.getReader().getLine() + ", column: " + lexer.getReader().getColumn() + ".\nBut got an unterminated object.");
                }
                if (currentToken.getType() != JsonTokenType.COLON) {
                    throw new JsonException("Expected " + JsonTokenType.COLON.getLabel() + " on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\nBut got '" + currentToken.getText() + "' instead.");
                }
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected a value on line: " + lexer.getReader().getLine() + ", column: " + lexer.getReader().getColumn() + ".\nBut got an unterminated object.");
                }
                if (currentToken.getType() == JsonTokenType.OPEN_CURLY) {
                    content.put(mapKey, this.parseObject(lexer));
                } else if (currentToken.getType() == JsonTokenType.OPEN_BRACKET) {
                    content.put(mapKey, this.parseArray(lexer));
                } else if (currentToken.getType().ordinal() >= JsonTokenType.NULL.ordinal()) {
                    content.put(mapKey, this.getValue(currentToken));
                } else {
                    throw new JsonException("Expected a value, an array, or an object on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\nBut got '" + currentToken.getText() + "' instead.");
                }
                previousToken = currentToken;
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected " + JsonTokenType.CLOSE_CURLY.getLabel() + " or " + JsonTokenType.COMMA.getLabel() + " on line: " + previousToken.getEndLine() + ", column: " + previousToken.getEndColumn() + ".\nBut got an unterminated object.");
                }
                if (currentToken.getType() == JsonTokenType.CLOSE_CURLY) break block14;
            } while (currentToken.getType() == JsonTokenType.COMMA);
            throw new JsonException("Expected a value or " + JsonTokenType.CLOSE_CURLY.getLabel() + " on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\nBut got '" + currentToken.getText() + "' instead.");
        }
        return content;
    }
}

