/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.exceptions.RealmPrimaryKeyConstraintException;
import io.realm.internal.CheckedRow;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.TableQuery;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class Table
implements NativeObject {
    private static final String TABLE_PREFIX = Util.getTablePrefix();
    private static final int TABLE_NAME_MAX_LENGTH = 63;
    public static final int CLASS_NAME_MAX_LENGTH = 63 - TABLE_PREFIX.length();
    public static final long INFINITE = -1L;
    public static final boolean NULLABLE = true;
    public static final boolean NOT_NULLABLE = false;
    public static final int NO_MATCH = -1;
    public static final int MAX_BINARY_SIZE = 0xFFFFF0;
    public static final int MAX_STRING_SIZE = 0xFFFFEF;
    private static final long nativeFinalizerPtr = Table.nativeGetFinalizerPtr();
    private final long nativeTableRefPtr;
    private final NativeContext context;
    private final OsSharedRealm sharedRealm;

    Table(OsSharedRealm sharedRealm, long nativeTableRefPointer) {
        this.context = sharedRealm.context;
        this.sharedRealm = sharedRealm;
        this.nativeTableRefPtr = nativeTableRefPointer;
        this.context.addReference(this);
    }

    @Override
    public long getNativePtr() {
        return this.nativeTableRefPtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public Table getTable() {
        return this;
    }

    public boolean isValid() {
        return this.nativeTableRefPtr != 0L && this.nativeIsValid(this.nativeTableRefPtr);
    }

    private void verifyColumnName(String name) {
        if (name.length() > 63) {
            throw new IllegalArgumentException("Column names are currently limited to max 63 characters.");
        }
    }

    public long addColumn(RealmFieldType type, String name, boolean isNullable) {
        this.verifyColumnName(name);
        switch (type) {
            case INTEGER: 
            case BOOLEAN: 
            case STRING: 
            case BINARY: 
            case DATE: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL128: 
            case OBJECT_ID: 
            case MIXED: 
            case UUID: {
                return this.nativeAddColumn(this.nativeTableRefPtr, type.getNativeValue(), name, isNullable);
            }
            case INTEGER_LIST: 
            case BOOLEAN_LIST: 
            case STRING_LIST: 
            case BINARY_LIST: 
            case DATE_LIST: 
            case FLOAT_LIST: 
            case DOUBLE_LIST: 
            case DECIMAL128_LIST: 
            case OBJECT_ID_LIST: 
            case UUID_LIST: 
            case MIXED_LIST: {
                return this.nativeAddPrimitiveListColumn(this.nativeTableRefPtr, type.getNativeValue() - 128, name, isNullable);
            }
            case STRING_TO_INTEGER_MAP: 
            case STRING_TO_BOOLEAN_MAP: 
            case STRING_TO_STRING_MAP: 
            case STRING_TO_BINARY_MAP: 
            case STRING_TO_DATE_MAP: 
            case STRING_TO_FLOAT_MAP: 
            case STRING_TO_DOUBLE_MAP: 
            case STRING_TO_DECIMAL128_MAP: 
            case STRING_TO_OBJECT_ID_MAP: 
            case STRING_TO_UUID_MAP: 
            case STRING_TO_MIXED_MAP: {
                return this.nativeAddPrimitiveDictionaryColumn(this.nativeTableRefPtr, type.getNativeValue() - 512, name, isNullable);
            }
            case INTEGER_SET: 
            case BOOLEAN_SET: 
            case STRING_SET: 
            case BINARY_SET: 
            case DATE_SET: 
            case FLOAT_SET: 
            case DOUBLE_SET: 
            case DECIMAL128_SET: 
            case OBJECT_ID_SET: 
            case UUID_SET: 
            case MIXED_SET: {
                return this.nativeAddPrimitiveSetColumn(this.nativeTableRefPtr, type.getNativeValue() - 256, name, isNullable);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    public long addColumn(RealmFieldType type, String name) {
        return this.addColumn(type, name, false);
    }

    public long addColumnLink(RealmFieldType type, String name, Table table) {
        this.verifyColumnName(name);
        return this.nativeAddColumnLink(this.nativeTableRefPtr, type.getNativeValue(), name, table.nativeTableRefPtr);
    }

    public long addColumnDictionaryLink(RealmFieldType type, String name, Table table) {
        this.verifyColumnName(name);
        return this.nativeAddColumnDictionaryLink(this.nativeTableRefPtr, type.getNativeValue(), name, table.nativeTableRefPtr);
    }

    public long addColumnSetLink(RealmFieldType type, String name, Table table) {
        this.verifyColumnName(name);
        return this.nativeAddColumnSetLink(this.nativeTableRefPtr, type.getNativeValue(), name, table.nativeTableRefPtr);
    }

    public void removeColumn(long columnKey) {
        String className = this.getClassName();
        String columnName = this.getColumnName(columnKey);
        String pkName = OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, this.getClassName());
        this.nativeRemoveColumn(this.nativeTableRefPtr, columnKey);
        if (columnName.equals(pkName)) {
            OsObjectStore.setPrimaryKeyForObject(this.sharedRealm, className, null);
        }
    }

    public void renameColumn(long columnKey, String newName) {
        this.verifyColumnName(newName);
        String oldName = this.nativeGetColumnName(this.nativeTableRefPtr, columnKey);
        String pkName = OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, this.getClassName());
        this.nativeRenameColumn(this.nativeTableRefPtr, columnKey, newName);
        if (oldName.equals(pkName)) {
            try {
                OsObjectStore.setPrimaryKeyForObject(this.sharedRealm, this.getClassName(), newName);
            }
            catch (Exception e) {
                this.nativeRenameColumn(this.nativeTableRefPtr, columnKey, oldName);
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isColumnNullable(long columnKey) {
        return this.nativeIsColumnNullable(this.nativeTableRefPtr, columnKey);
    }

    public void convertColumnToNullable(long columnKey) {
        if (this.sharedRealm.isSyncRealm()) {
            throw new IllegalStateException("This method is only available for non-synchronized Realms");
        }
        this.nativeConvertColumnToNullable(this.nativeTableRefPtr, columnKey, this.isPrimaryKey(columnKey));
    }

    public void convertColumnToNotNullable(long columnKey) {
        if (this.sharedRealm.isSyncRealm()) {
            throw new IllegalStateException("This method is only available for non-synchronized Realms");
        }
        this.nativeConvertColumnToNotNullable(this.nativeTableRefPtr, columnKey, this.isPrimaryKey(columnKey));
    }

    public long size() {
        return this.nativeSize(this.nativeTableRefPtr);
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public void clear() {
        this.checkImmutable();
        this.nativeClear(this.nativeTableRefPtr);
    }

    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativeTableRefPtr);
    }

    public String getColumnName(long columnKey) {
        return this.nativeGetColumnName(this.nativeTableRefPtr, columnKey);
    }

    public String[] getColumnNames() {
        return this.nativeGetColumnNames(this.nativeTableRefPtr);
    }

    public long getColumnKey(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnKey(this.nativeTableRefPtr, columnName);
    }

    public RealmFieldType getColumnType(long columnKey) {
        return RealmFieldType.fromNativeValue(this.nativeGetColumnType(this.nativeTableRefPtr, columnKey));
    }

    public void moveLastOver(long rowKey) {
        this.checkImmutable();
        this.nativeMoveLastOver(this.nativeTableRefPtr, rowKey);
    }

    private boolean isPrimaryKey(long columnKey) {
        return this.getColumnName(columnKey).equals(OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, this.getClassName()));
    }

    public static void throwDuplicatePrimaryKeyException(Object value) {
        throw new RealmPrimaryKeyConstraintException("Value already exists: " + value);
    }

    public OsSharedRealm getSharedRealm() {
        return this.sharedRealm;
    }

    public long getLong(long columnKey, long rowKey) {
        return this.nativeGetLong(this.nativeTableRefPtr, columnKey, rowKey);
    }

    public boolean getBoolean(long columnKey, long rowKey) {
        return this.nativeGetBoolean(this.nativeTableRefPtr, columnKey, rowKey);
    }

    public float getFloat(long columnKey, long rowKey) {
        return this.nativeGetFloat(this.nativeTableRefPtr, columnKey, rowKey);
    }

    public double getDouble(long columnKey, long rowKey) {
        return this.nativeGetDouble(this.nativeTableRefPtr, columnKey, rowKey);
    }

    public Date getDate(long columnKey, long rowKey) {
        return new Date(this.nativeGetTimestamp(this.nativeTableRefPtr, columnKey, rowKey));
    }

    public String getString(long columnKey, long rowKey) {
        return this.nativeGetString(this.nativeTableRefPtr, columnKey, rowKey);
    }

    public byte[] getBinaryByteArray(long columnKey, long rowKey) {
        return this.nativeGetByteArray(this.nativeTableRefPtr, columnKey, rowKey);
    }

    public long getLink(long columnKey, long rowKey) {
        return this.nativeGetLink(this.nativeTableRefPtr, columnKey, rowKey);
    }

    public Table getLinkTarget(long columnKey) {
        long nativeTablePointer = this.nativeGetLinkTarget(this.nativeTableRefPtr, columnKey);
        return new Table(this.sharedRealm, nativeTablePointer);
    }

    public UncheckedRow getUncheckedRow(long rowKey) {
        return UncheckedRow.getByRowKey(this.context, this, rowKey);
    }

    public UncheckedRow getUncheckedRowByPointer(long nativeRowPointer) {
        return UncheckedRow.getByRowPointer(this.context, this, nativeRowPointer);
    }

    public CheckedRow getCheckedRow(long objKey) {
        return CheckedRow.get(this.context, this, objKey);
    }

    public void setLong(long columnKey, long rowKey, long value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetLong(this.nativeTableRefPtr, columnKey, rowKey, value, isDefault);
    }

    public void incrementLong(long columnKey, long rowKey, long value) {
        this.checkImmutable();
        Table.nativeIncrementLong(this.nativeTableRefPtr, columnKey, rowKey, value);
    }

    public void setBoolean(long columnKey, long rowKey, boolean value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetBoolean(this.nativeTableRefPtr, columnKey, rowKey, value, isDefault);
    }

    public void setFloat(long columnKey, long rowKey, float value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetFloat(this.nativeTableRefPtr, columnKey, rowKey, value, isDefault);
    }

    public void setDouble(long columnKey, long rowKey, double value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetDouble(this.nativeTableRefPtr, columnKey, rowKey, value, isDefault);
    }

    public void setDate(long columnKey, long rowKey, Date date, boolean isDefault) {
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        this.checkImmutable();
        Table.nativeSetTimestamp(this.nativeTableRefPtr, columnKey, rowKey, date.getTime(), isDefault);
    }

    public void setString(long columnKey, long rowKey, @Nullable String value, boolean isDefault) {
        this.checkImmutable();
        if (value == null) {
            Table.nativeSetNull(this.nativeTableRefPtr, columnKey, rowKey, isDefault);
        } else {
            Table.nativeSetString(this.nativeTableRefPtr, columnKey, rowKey, value, isDefault);
        }
    }

    public void setBinaryByteArray(long columnKey, long rowKey, byte[] data, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetByteArray(this.nativeTableRefPtr, columnKey, rowKey, data, isDefault);
    }

    public void setDecimal128(long columnKey, long rowKey, @Nullable Decimal128 value, boolean isDefault) {
        this.checkImmutable();
        if (value == null) {
            Table.nativeSetNull(this.nativeTableRefPtr, columnKey, rowKey, isDefault);
        } else {
            Table.nativeSetDecimal128(this.nativeTableRefPtr, columnKey, rowKey, value.getLow(), value.getHigh(), isDefault);
        }
    }

    public void setObjectId(long columnKey, long rowKey, @Nullable ObjectId value, boolean isDefault) {
        this.checkImmutable();
        if (value == null) {
            Table.nativeSetNull(this.nativeTableRefPtr, columnKey, rowKey, isDefault);
        } else {
            Table.nativeSetObjectId(this.nativeTableRefPtr, columnKey, rowKey, value.toString(), isDefault);
        }
    }

    public void setUUID(long columnKey, long rowKey, @Nullable UUID value, boolean isDefault) {
        this.checkImmutable();
        if (value == null) {
            Table.nativeSetNull(this.nativeTableRefPtr, columnKey, rowKey, isDefault);
        } else {
            Table.nativeSetUUID(this.nativeTableRefPtr, columnKey, rowKey, value.toString(), isDefault);
        }
    }

    public void setRealmAny(long columnKey, long rowKey, long nativePtr, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetRealmAny(this.nativeTableRefPtr, columnKey, rowKey, nativePtr, isDefault);
    }

    public void setLink(long columnKey, long rowKey, long value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetLink(this.nativeTableRefPtr, columnKey, rowKey, value, isDefault);
    }

    public void setNull(long columnKey, long rowKey, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetNull(this.nativeTableRefPtr, columnKey, rowKey, isDefault);
    }

    public void addSearchIndex(long columnKey) {
        this.checkImmutable();
        this.nativeAddSearchIndex(this.nativeTableRefPtr, columnKey);
    }

    public void removeSearchIndex(long columnKey) {
        this.checkImmutable();
        this.nativeRemoveSearchIndex(this.nativeTableRefPtr, columnKey);
    }

    public boolean hasSearchIndex(long columnKey) {
        return this.nativeHasSearchIndex(this.nativeTableRefPtr, columnKey);
    }

    public boolean isNullLink(long columnKey, long rowKey) {
        return this.nativeIsNullLink(this.nativeTableRefPtr, columnKey, rowKey);
    }

    public void nullifyLink(long columnKey, long rowKey) {
        Table.nativeNullifyLink(this.nativeTableRefPtr, columnKey, rowKey);
    }

    boolean isImmutable() {
        return this.sharedRealm != null && !this.sharedRealm.isInTransaction();
    }

    void checkImmutable() {
        if (this.isImmutable()) {
            Table.throwImmutable();
        }
    }

    public long count(long columnKey, long value) {
        return this.nativeCountLong(this.nativeTableRefPtr, columnKey, value);
    }

    public long count(long columnKey, float value) {
        return this.nativeCountFloat(this.nativeTableRefPtr, columnKey, value);
    }

    public long count(long columnKey, double value) {
        return this.nativeCountDouble(this.nativeTableRefPtr, columnKey, value);
    }

    public long count(long columnKey, String value) {
        return this.nativeCountString(this.nativeTableRefPtr, columnKey, value);
    }

    public TableQuery where() {
        long nativeQueryPtr = this.nativeWhere(this.nativeTableRefPtr);
        return new TableQuery(this.context, this, nativeQueryPtr);
    }

    public long findFirstLong(long columnKey, long value) {
        return Table.nativeFindFirstInt(this.nativeTableRefPtr, columnKey, value);
    }

    public long findFirstBoolean(long columnKey, boolean value) {
        return this.nativeFindFirstBool(this.nativeTableRefPtr, columnKey, value);
    }

    public long findFirstFloat(long columnKey, float value) {
        return this.nativeFindFirstFloat(this.nativeTableRefPtr, columnKey, value);
    }

    public long findFirstDouble(long columnKey, double value) {
        return this.nativeFindFirstDouble(this.nativeTableRefPtr, columnKey, value);
    }

    public long findFirstDate(long columnKey, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return this.nativeFindFirstTimestamp(this.nativeTableRefPtr, columnKey, date.getTime());
    }

    public long findFirstString(long columnKey, String value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return Table.nativeFindFirstString(this.nativeTableRefPtr, columnKey, value);
    }

    public long findFirstDecimal128(long columnKey, Decimal128 value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return Table.nativeFindFirstDecimal128(this.nativeTableRefPtr, columnKey, value.getLow(), value.getHigh());
    }

    public long findFirstObjectId(long columnKey, ObjectId value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return Table.nativeFindFirstObjectId(this.nativeTableRefPtr, columnKey, value.toString());
    }

    public long findFirstUUID(long columnKey, UUID value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return Table.nativeFindFirstUUID(this.nativeTableRefPtr, columnKey, value.toString());
    }

    public long findFirstNull(long columnKey) {
        return Table.nativeFindFirstNull(this.nativeTableRefPtr, columnKey);
    }

    @Nullable
    public String getName() {
        return this.nativeGetName(this.nativeTableRefPtr);
    }

    public String getClassName() {
        String name = Table.getClassNameForTable(this.getName());
        if (Util.isEmptyString(name)) {
            throw new IllegalStateException("This object class is no longer part of the schema for the Realm file. It is therefor not possible to access the schema name.");
        }
        return name;
    }

    public String toString() {
        long columnCount = this.getColumnCount();
        String name = this.getName();
        StringBuilder stringBuilder = new StringBuilder("The Table ");
        if (name != null && !name.isEmpty()) {
            stringBuilder.append(this.getName());
            stringBuilder.append(" ");
        }
        stringBuilder.append("contains ");
        stringBuilder.append(columnCount);
        stringBuilder.append(" columns: ");
        boolean isFirst = true;
        for (String column : this.getColumnNames()) {
            if (!isFirst) {
                stringBuilder.append(", ");
            }
            isFirst = false;
            stringBuilder.append(column);
        }
        stringBuilder.append(".");
        stringBuilder.append(" And ");
        stringBuilder.append(this.size());
        stringBuilder.append(" rows.");
        return stringBuilder.toString();
    }

    private static void throwImmutable() {
        throw new IllegalStateException("Cannot modify managed objects outside of a write transaction.");
    }

    public boolean hasSameSchema(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        return this.nativeHasSameSchema(this.nativeTableRefPtr, table.nativeTableRefPtr);
    }

    public Table freeze(OsSharedRealm frozenRealm) {
        if (!frozenRealm.isFrozen()) {
            throw new IllegalArgumentException("Frozen Realm required");
        }
        return new Table(frozenRealm, Table.nativeFreeze(frozenRealm.getNativePtr(), this.nativeTableRefPtr));
    }

    public boolean isEmbedded() {
        return Table.nativeIsEmbedded(this.nativeTableRefPtr);
    }

    public boolean setEmbedded(boolean embedded) {
        return this.setEmbedded(embedded, false);
    }

    public boolean setEmbedded(boolean embedded, boolean handleBackLinks) {
        return Table.nativeSetEmbedded(this.nativeTableRefPtr, embedded, handleBackLinks);
    }

    @Nullable
    public static String getClassNameForTable(@Nullable String name) {
        if (name == null) {
            return null;
        }
        if (!name.startsWith(TABLE_PREFIX)) {
            return name;
        }
        return name.substring(TABLE_PREFIX.length());
    }

    public static String getTableNameForClass(String name) {
        if (name == null) {
            return null;
        }
        return TABLE_PREFIX + name;
    }

    private native boolean nativeIsValid(long var1);

    private native long nativeAddColumn(long var1, int var3, String var4, boolean var5);

    private native long nativeAddPrimitiveListColumn(long var1, int var3, String var4, boolean var5);

    private native long nativeAddPrimitiveDictionaryColumn(long var1, int var3, String var4, boolean var5);

    private native long nativeAddPrimitiveSetColumn(long var1, int var3, String var4, boolean var5);

    private native long nativeAddColumnLink(long var1, int var3, String var4, long var5);

    private native long nativeAddColumnDictionaryLink(long var1, int var3, String var4, long var5);

    private native long nativeAddColumnSetLink(long var1, int var3, String var4, long var5);

    private native void nativeRenameColumn(long var1, long var3, String var5);

    private native void nativeRemoveColumn(long var1, long var3);

    private native boolean nativeIsColumnNullable(long var1, long var3);

    private native void nativeConvertColumnToNullable(long var1, long var3, boolean var5);

    private native void nativeConvertColumnToNotNullable(long var1, long var3, boolean var5);

    private native long nativeSize(long var1);

    private native void nativeClear(long var1);

    private native long nativeGetColumnCount(long var1);

    private native String nativeGetColumnName(long var1, long var3);

    private native String[] nativeGetColumnNames(long var1);

    private native long nativeGetColumnKey(long var1, String var3);

    private native int nativeGetColumnType(long var1, long var3);

    private native void nativeMoveLastOver(long var1, long var3);

    private native long nativeGetLong(long var1, long var3, long var5);

    private native boolean nativeGetBoolean(long var1, long var3, long var5);

    private native float nativeGetFloat(long var1, long var3, long var5);

    private native double nativeGetDouble(long var1, long var3, long var5);

    private native long nativeGetTimestamp(long var1, long var3, long var5);

    private native String nativeGetString(long var1, long var3, long var5);

    private native byte[] nativeGetByteArray(long var1, long var3, long var5);

    private native long nativeGetLink(long var1, long var3, long var5);

    private native long nativeGetLinkTarget(long var1, long var3);

    private native long[] nativeGetDecimal128(long var1, long var3, long var5);

    private native String nativeGetObjectId(long var1, long var3, long var5);

    private native boolean nativeIsNull(long var1, long var3, long var5);

    native long nativeGetRowPtr(long var1, long var3);

    public static native void nativeSetLong(long var0, long var2, long var4, long var6, boolean var8);

    public static native void nativeIncrementLong(long var0, long var2, long var4, long var6);

    public static native void nativeSetBoolean(long var0, long var2, long var4, boolean var6, boolean var7);

    public static native void nativeSetFloat(long var0, long var2, long var4, float var6, boolean var7);

    public static native void nativeSetDouble(long var0, long var2, long var4, double var6, boolean var8);

    public static native void nativeSetTimestamp(long var0, long var2, long var4, long var6, boolean var8);

    public static native void nativeSetString(long var0, long var2, long var4, String var6, boolean var7);

    public static native void nativeSetNull(long var0, long var2, long var4, boolean var6);

    public static native void nativeSetByteArray(long var0, long var2, long var4, byte[] var6, boolean var7);

    public static native void nativeSetDecimal128(long var0, long var2, long var4, long var6, long var8, boolean var10);

    public static native void nativeSetObjectId(long var0, long var2, long var4, String var6, boolean var7);

    public static native void nativeSetUUID(long var0, long var2, long var4, String var6, boolean var7);

    public static native void nativeSetLink(long var0, long var2, long var4, long var6, boolean var8);

    public static native void nativeSetRealmAny(long var0, long var2, long var4, long var6, boolean var8);

    private native void nativeAddSearchIndex(long var1, long var3);

    private native void nativeRemoveSearchIndex(long var1, long var3);

    private native boolean nativeHasSearchIndex(long var1, long var3);

    private native boolean nativeIsNullLink(long var1, long var3, long var5);

    public static native void nativeNullifyLink(long var0, long var2, long var4);

    private native long nativeCountLong(long var1, long var3, long var5);

    private native long nativeCountFloat(long var1, long var3, float var5);

    private native long nativeCountDouble(long var1, long var3, double var5);

    private native long nativeCountString(long var1, long var3, String var5);

    private native long nativeWhere(long var1);

    public static native long nativeFindFirstInt(long var0, long var2, long var4);

    private native long nativeFindFirstBool(long var1, long var3, boolean var5);

    private native long nativeFindFirstFloat(long var1, long var3, float var5);

    private native long nativeFindFirstDouble(long var1, long var3, double var5);

    private native long nativeFindFirstTimestamp(long var1, long var3, long var5);

    public static native long nativeFindFirstString(long var0, long var2, String var4);

    public static native long nativeFindFirstDecimal128(long var0, long var2, long var4, long var6);

    public static native long nativeFindFirstObjectId(long var0, long var2, String var4);

    public static native long nativeFindFirstUUID(long var0, long var2, String var4);

    public static native long nativeFindFirstNull(long var0, long var2);

    private native String nativeGetName(long var1);

    private native boolean nativeHasSameSchema(long var1, long var3);

    private static native long nativeGetFinalizerPtr();

    private static native long nativeFreeze(long var0, long var2);

    private static native boolean nativeIsEmbedded(long var0);

    private static native boolean nativeSetEmbedded(long var0, boolean var2, boolean var3);
}

