/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.ObservableMap;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.android.TypeUtils;
import io.realm.internal.core.NativeRealmAny;
import io.realm.internal.util.Pair;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class OsMap
implements NativeObject {
    public static final int NOT_FOUND = -1;
    private static final long nativeFinalizerPtr = OsMap.nativeGetFinalizerPtr();
    private final long nativePtr;
    private final NativeContext context;
    private final Table targetTable;

    public OsMap(UncheckedRow row, long columnKey) {
        OsSharedRealm osSharedRealm = row.getTable().getSharedRealm();
        long[] pointers = OsMap.nativeCreate(osSharedRealm.getNativePtr(), row.getNativePtr(), columnKey);
        this.nativePtr = pointers[0];
        this.targetTable = pointers[1] != -1L ? new Table(osSharedRealm, pointers[1]) : null;
        this.context = osSharedRealm.context;
        this.context.addReference(this);
    }

    private OsMap(OsSharedRealm osSharedRealm, long nativePtr, Table targetTable) {
        this.nativePtr = nativePtr;
        this.targetTable = targetTable;
        this.context = osSharedRealm.context;
        this.context.addReference(this);
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public long size() {
        return OsMap.nativeSize(this.nativePtr);
    }

    public boolean containsKey(Object key) {
        return OsMap.nativeContainsKey(this.nativePtr, (String)key);
    }

    public boolean isValid() {
        return OsMap.nativeIsValid(this.nativePtr);
    }

    public boolean containsPrimitiveValue(@Nullable Object value) {
        if (value == null) {
            return OsMap.nativeContainsNull(this.nativePtr);
        }
        if (value instanceof Integer) {
            return OsMap.nativeContainsLong(this.nativePtr, ((Integer)value).longValue());
        }
        if (value instanceof Long) {
            return OsMap.nativeContainsLong(this.nativePtr, (Long)value);
        }
        if (value instanceof Double) {
            return OsMap.nativeContainsDouble(this.nativePtr, (Double)value);
        }
        if (value instanceof Short) {
            return OsMap.nativeContainsLong(this.nativePtr, ((Short)value).longValue());
        }
        if (value instanceof Byte) {
            return OsMap.nativeContainsLong(this.nativePtr, ((Byte)value).longValue());
        }
        if (value instanceof Boolean) {
            return OsMap.nativeContainsBoolean(this.nativePtr, (Boolean)value);
        }
        if (value instanceof String) {
            return OsMap.nativeContainsString(this.nativePtr, (String)value);
        }
        if (value instanceof Byte[]) {
            return OsMap.nativeContainsBinary(this.nativePtr, TypeUtils.convertNonPrimitiveBinaryToPrimitive((Byte[])value));
        }
        if (value instanceof byte[]) {
            return OsMap.nativeContainsBinary(this.nativePtr, (byte[])value);
        }
        if (value instanceof Float) {
            return OsMap.nativeContainsFloat(this.nativePtr, ((Float)value).floatValue());
        }
        if (value instanceof UUID) {
            return OsMap.nativeContainsUUID(this.nativePtr, value.toString());
        }
        if (value instanceof ObjectId) {
            return OsMap.nativeContainsObjectId(this.nativePtr, ((ObjectId)value).toString());
        }
        if (value instanceof Date) {
            return OsMap.nativeContainsDate(this.nativePtr, ((Date)value).getTime());
        }
        if (value instanceof Decimal128) {
            Decimal128 decimal128 = (Decimal128)value;
            return OsMap.nativeContainsDecimal128(this.nativePtr, decimal128.getHigh(), decimal128.getLow());
        }
        throw new IllegalArgumentException("Invalid object type: " + value.getClass().getCanonicalName());
    }

    public boolean containsRealmAnyValue(long realmAnyPtr) {
        return OsMap.nativeContainsRealmAny(this.nativePtr, realmAnyPtr);
    }

    public boolean containsRealmModel(long objKey, long tablePtr) {
        return OsMap.nativeContainsRealmModel(this.nativePtr, objKey, tablePtr);
    }

    public void clear() {
        OsMap.nativeClear(this.nativePtr);
    }

    public Pair<Table, Long> tableAndKeyPtrs() {
        return new Pair<Table, Long>(this.targetTable, OsMap.nativeKeys(this.nativePtr));
    }

    public Pair<Table, Long> tableAndValuePtrs() {
        return new Pair<Table, Long>(this.targetTable, OsMap.nativeValues(this.nativePtr));
    }

    public OsMap freeze(OsSharedRealm osSharedRealm) {
        return new OsMap(osSharedRealm, OsMap.nativeFreeze(this.nativePtr, osSharedRealm.getNativePtr()), this.targetTable);
    }

    public void put(Object key, @Nullable Object value) {
        if (value == null) {
            try {
                OsMap.nativePutNull(this.nativePtr, (String)key);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Value cannot be null")) {
                    throw new NullPointerException(e.getMessage());
                }
                throw e;
            }
        } else {
            String valueClassName = value.getClass().getCanonicalName();
            if (Long.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutLong(this.nativePtr, (String)key, (Long)value);
            } else if (Integer.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutLong(this.nativePtr, (String)key, ((Integer)value).intValue());
            } else if (Short.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutLong(this.nativePtr, (String)key, ((Short)value).shortValue());
            } else if (Byte.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutLong(this.nativePtr, (String)key, ((Byte)value).byteValue());
            } else if (Float.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutFloat(this.nativePtr, (String)key, ((Float)value).floatValue());
            } else if (Double.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutDouble(this.nativePtr, (String)key, (Double)value);
            } else if (String.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutString(this.nativePtr, (String)key, (String)value);
            } else if (Boolean.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutBoolean(this.nativePtr, (String)key, (Boolean)value);
            } else if (Date.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutDate(this.nativePtr, (String)key, ((Date)value).getTime());
            } else if (Decimal128.class.getCanonicalName().equals(valueClassName)) {
                Decimal128 decimal128 = (Decimal128)value;
                OsMap.nativePutDecimal128(this.nativePtr, (String)key, decimal128.getHigh(), decimal128.getLow());
            } else if (Byte[].class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutBinary(this.nativePtr, (String)key, TypeUtils.convertNonPrimitiveBinaryToPrimitive((Byte[])value));
            } else if (byte[].class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutBinary(this.nativePtr, (String)key, (byte[])value);
            } else if (ObjectId.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutObjectId(this.nativePtr, (String)key, ((ObjectId)value).toString());
            } else if (UUID.class.getCanonicalName().equals(valueClassName)) {
                OsMap.nativePutUUID(this.nativePtr, (String)key, value.toString());
            } else {
                throw new UnsupportedOperationException("Class '" + valueClassName + "' not supported.");
            }
        }
    }

    public void putRow(Object key, long objKey) {
        OsMap.nativePutRow(this.nativePtr, (String)key, objKey);
    }

    public void putRealmAny(Object key, long nativeRealmAnyPtr) {
        OsMap.nativePutRealmAny(this.nativePtr, (String)key, nativeRealmAnyPtr);
    }

    public void remove(Object key) {
        OsMap.nativeRemove(this.nativePtr, (String)key);
    }

    public long getModelRowKey(Object key) {
        return OsMap.nativeGetRow(this.nativePtr, (String)key);
    }

    @Nullable
    public Object get(Object key) {
        return OsMap.nativeGetValue(this.nativePtr, (String)key);
    }

    public long getRealmAnyPtr(Object key) {
        return OsMap.nativeGetRealmAnyPtr(this.nativePtr, (String)key);
    }

    public long createAndPutEmbeddedObject(Object key) {
        return OsMap.nativeCreateAndPutEmbeddedObject(this.nativePtr, (String)key);
    }

    public <K> Pair<K, Object> getEntryForPrimitive(int position) {
        Object[] entry = OsMap.nativeGetEntryForPrimitive(this.nativePtr, position);
        String key = (String)entry[0];
        return new Pair<String, Object>(key, entry[1]);
    }

    public <K> Pair<K, Long> getKeyObjRowPair(int position) {
        Object[] entry = OsMap.nativeGetEntryForModel(this.nativePtr, position);
        String key = (String)entry[0];
        long objRow = (Long)entry[1];
        if (objRow == -1L) {
            return new Pair<String, Long>(key, -1L);
        }
        return new Pair<String, Long>(key, objRow);
    }

    public <K> Pair<K, NativeRealmAny> getKeyRealmAnyPair(int position) {
        Object[] entry = OsMap.nativeGetEntryForRealmAny(this.nativePtr, position);
        String key = (String)entry[0];
        NativeRealmAny nativeRealmAny = new NativeRealmAny((Long)entry[1]);
        return new Pair<String, NativeRealmAny>(key, nativeRealmAny);
    }

    public void startListening(ObservableMap observableMap) {
        OsMap.nativeStartListening(this.nativePtr, observableMap);
    }

    public void stopListening() {
        OsMap.nativeStopListening(this.nativePtr);
    }

    private static native long nativeGetFinalizerPtr();

    private static native long[] nativeCreate(long var0, long var2, long var4);

    private static native Object nativeGetValue(long var0, String var2);

    private static native long nativeGetRealmAnyPtr(long var0, String var2);

    private static native long nativeGetRow(long var0, String var2);

    private static native void nativePutNull(long var0, String var2);

    private static native void nativePutLong(long var0, String var2, long var3);

    private static native void nativePutFloat(long var0, String var2, float var3);

    private static native void nativePutDouble(long var0, String var2, double var3);

    private static native void nativePutString(long var0, String var2, String var3);

    private static native void nativePutBoolean(long var0, String var2, boolean var3);

    private static native void nativePutDate(long var0, String var2, long var3);

    private static native void nativePutDecimal128(long var0, String var2, long var3, long var5);

    private static native void nativePutBinary(long var0, String var2, byte[] var3);

    private static native void nativePutObjectId(long var0, String var2, String var3);

    private static native void nativePutUUID(long var0, String var2, String var3);

    private static native void nativePutRealmAny(long var0, String var2, long var3);

    private static native void nativePutRow(long var0, String var2, long var3);

    private static native long nativeSize(long var0);

    private static native boolean nativeContainsKey(long var0, String var2);

    private static native boolean nativeIsValid(long var0);

    private static native void nativeClear(long var0);

    private static native void nativeRemove(long var0, String var2);

    private static native long nativeKeys(long var0);

    private static native long nativeValues(long var0);

    private static native long nativeFreeze(long var0, long var2);

    private static native long nativeCreateAndPutEmbeddedObject(long var0, String var2);

    private static native Object[] nativeGetEntryForModel(long var0, int var2);

    private static native Object[] nativeGetEntryForRealmAny(long var0, int var2);

    private static native Object[] nativeGetEntryForPrimitive(long var0, int var2);

    private static native boolean nativeContainsNull(long var0);

    private static native boolean nativeContainsDouble(long var0, double var2);

    private static native boolean nativeContainsLong(long var0, long var2);

    private static native boolean nativeContainsBoolean(long var0, boolean var2);

    private static native boolean nativeContainsString(long var0, String var2);

    private static native boolean nativeContainsBinary(long var0, byte[] var2);

    private static native boolean nativeContainsFloat(long var0, float var2);

    private static native boolean nativeContainsObjectId(long var0, String var2);

    private static native boolean nativeContainsUUID(long var0, String var2);

    private static native boolean nativeContainsDate(long var0, long var2);

    private static native boolean nativeContainsDecimal128(long var0, long var2, long var4);

    private static native boolean nativeContainsRealmAny(long var0, long var2);

    private static native boolean nativeContainsRealmModel(long var0, long var2, long var4);

    private static native void nativeStartListening(long var0, ObservableMap var2);

    private static native void nativeStopListening(long var0);
}

