/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.BaseRealm;
import io.realm.BinaryRealmAnyOperator;
import io.realm.BooleanRealmAnyOperator;
import io.realm.DateRealmAnyOperator;
import io.realm.Decimal128RealmAnyOperator;
import io.realm.DoubleRealmAnyOperator;
import io.realm.FloatRealmAnyOperator;
import io.realm.IntegerRealmAnyOperator;
import io.realm.NullRealmAnyOperator;
import io.realm.ObjectIdRealmAnyOperator;
import io.realm.RealmAnyOperator;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.RealmModelOperator;
import io.realm.RealmObject;
import io.realm.StringRealmAnyOperator;
import io.realm.UUIDRealmAnyOperator;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class RealmAny {
    @Nonnull
    private final RealmAnyOperator operator;

    RealmAny(@Nonnull RealmAnyOperator operator) {
        this.operator = operator;
    }

    final long getNativePtr() {
        return this.operator.getNativePtr();
    }

    public Type getType() {
        return this.operator.getType();
    }

    @Nullable
    public Class<?> getValueClass() {
        return this.operator.getTypedClass();
    }

    public static RealmAny valueOf(@Nullable Byte value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new IntegerRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable Short value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new IntegerRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable Integer value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new IntegerRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable Long value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new IntegerRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable Boolean value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new BooleanRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable Float value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new FloatRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable Double value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new DoubleRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable String value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new StringRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable byte[] value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new BinaryRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable Date value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new DateRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable ObjectId value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new ObjectIdRealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable Decimal128 value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new Decimal128RealmAnyOperator(value));
    }

    public static RealmAny valueOf(@Nullable UUID value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new UUIDRealmAnyOperator(value));
    }

    public static RealmAny nullValue() {
        return new RealmAny(new NullRealmAnyOperator());
    }

    public static RealmAny valueOf(@Nullable RealmModel value) {
        return new RealmAny(value == null ? new NullRealmAnyOperator() : new RealmModelOperator(value));
    }

    public boolean isNull() {
        return this.getType() == Type.NULL;
    }

    public Byte asByte() {
        Number value = this.operator.getValue(Number.class);
        return value == null ? null : Byte.valueOf(value.byteValue());
    }

    public Short asShort() {
        Number value = this.operator.getValue(Number.class);
        return value == null ? null : Short.valueOf(value.shortValue());
    }

    public Integer asInteger() {
        Number value = this.operator.getValue(Number.class);
        return value == null ? null : Integer.valueOf(value.intValue());
    }

    public Long asLong() {
        Number value = this.operator.getValue(Number.class);
        return value == null ? null : Long.valueOf(value.longValue());
    }

    public Boolean asBoolean() {
        return this.operator.getValue(Boolean.class);
    }

    public Float asFloat() {
        return this.operator.getValue(Float.class);
    }

    public Double asDouble() {
        return this.operator.getValue(Double.class);
    }

    public String asString() {
        return this.operator.getValue(String.class);
    }

    public byte[] asBinary() {
        return this.operator.getValue(byte[].class);
    }

    public Date asDate() {
        return this.operator.getValue(Date.class);
    }

    public ObjectId asObjectId() {
        return this.operator.getValue(ObjectId.class);
    }

    public UUID asUUID() {
        return this.operator.getValue(UUID.class);
    }

    public Decimal128 asDecimal128() {
        return this.operator.getValue(Decimal128.class);
    }

    public <T extends RealmModel> T asRealmModel(Class<T> clazz) {
        return (T)((RealmModel)this.operator.getValue(clazz));
    }

    static RealmAny valueOf(@Nullable Object value) {
        if (value == null) {
            return RealmAny.nullValue();
        }
        if (value instanceof Boolean) {
            return RealmAny.valueOf((Boolean)value);
        }
        if (value instanceof Byte) {
            return RealmAny.valueOf((Byte)value);
        }
        if (value instanceof Short) {
            return RealmAny.valueOf((Short)value);
        }
        if (value instanceof Integer) {
            return RealmAny.valueOf((Integer)value);
        }
        if (value instanceof Long) {
            return RealmAny.valueOf((Long)value);
        }
        if (value instanceof Float) {
            return RealmAny.valueOf((Float)value);
        }
        if (value instanceof Double) {
            return RealmAny.valueOf((Double)value);
        }
        if (value instanceof Decimal128) {
            return RealmAny.valueOf((Decimal128)value);
        }
        if (value instanceof String) {
            return RealmAny.valueOf((String)value);
        }
        if (value instanceof byte[]) {
            return RealmAny.valueOf((byte[])value);
        }
        if (value instanceof Date) {
            return RealmAny.valueOf((Date)value);
        }
        if (value instanceof ObjectId) {
            return RealmAny.valueOf((ObjectId)value);
        }
        if (value instanceof UUID) {
            return RealmAny.valueOf((UUID)value);
        }
        if (value instanceof RealmAny) {
            return (RealmAny)value;
        }
        if (RealmModel.class.isAssignableFrom(value.getClass())) {
            RealmModel model = (RealmModel)value;
            if (!RealmObject.isValid(model) || !RealmObject.isManaged(model)) {
                throw new IllegalArgumentException("RealmObject is not a valid managed object.");
            }
            return RealmAny.valueOf(model);
        }
        throw new IllegalArgumentException("Type not supported on RealmAny: " + value.getClass().getSimpleName());
    }

    public final int hashCode() {
        return this.operator.hashCode();
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public final boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RealmAny)) {
            return false;
        }
        RealmAny otherRealmAny = (RealmAny)other;
        return this.operator.equals(otherRealmAny.operator);
    }

    public final boolean coercedEquals(@Nullable RealmAny other) {
        if (other == null) {
            return false;
        }
        return this.operator.coercedEquals(other.operator);
    }

    public String toString() {
        return this.operator.toString();
    }

    void checkValidObject(BaseRealm realm) {
        this.operator.checkValidObject(realm);
    }

    public static enum Type {
        INTEGER(RealmFieldType.INTEGER, Long.class),
        BOOLEAN(RealmFieldType.BOOLEAN, Boolean.class),
        STRING(RealmFieldType.STRING, String.class),
        BINARY(RealmFieldType.BINARY, Byte[].class),
        DATE(RealmFieldType.DATE, Date.class),
        FLOAT(RealmFieldType.FLOAT, Float.class),
        DOUBLE(RealmFieldType.DOUBLE, Double.class),
        DECIMAL128(RealmFieldType.DECIMAL128, Decimal128.class),
        OBJECT_ID(RealmFieldType.OBJECT_ID, ObjectId.class),
        OBJECT(RealmFieldType.TYPED_LINK, RealmModel.class),
        UUID(RealmFieldType.UUID, UUID.class),
        NULL(null, null);

        private static final Type[] realmFieldToRealmAnyTypeMap;
        private final Class<?> clazz;
        private final RealmFieldType realmFieldType;

        public static Type fromNativeValue(int realmFieldType) {
            if (realmFieldType == -1) {
                return NULL;
            }
            return realmFieldToRealmAnyTypeMap[realmFieldType];
        }

        private Type(RealmFieldType realmFieldType, Class<?> clazz) {
            this.realmFieldType = realmFieldType;
            this.clazz = clazz;
        }

        public Class<?> getTypedClass() {
            return this.clazz;
        }

        static {
            realmFieldToRealmAnyTypeMap = new Type[19];
            for (Type realmAnyType : Type.values()) {
                if (realmAnyType == NULL) continue;
                int nativeValue = realmAnyType.realmFieldType.getNativeValue();
                Type.realmFieldToRealmAnyTypeMap[nativeValue] = realmAnyType;
            }
            Type.realmFieldToRealmAnyTypeMap[RealmFieldType.OBJECT.getNativeValue()] = OBJECT;
        }
    }
}

