/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.core;

import io.realm.RealmAny;
import io.realm.RealmModel;
import io.realm.internal.Keep;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Row;
import io.realm.internal.Table;
import java.util.Date;
import java.util.UUID;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@Keep
public class NativeRealmAny
implements NativeObject {
    private static final long nativeFinalizerPtr = NativeRealmAny.nativeGetFinalizerPtr();
    private final long nativePtr;

    public NativeRealmAny(long nativePtr) {
        this.nativePtr = nativePtr;
        NativeContext.dummyContext.addReference(this);
    }

    public NativeRealmAny(Boolean value) {
        this(NativeRealmAny.nativeCreateBoolean(value));
    }

    public NativeRealmAny(Number value) {
        this(NativeRealmAny.nativeCreateLong(value.longValue()));
    }

    public NativeRealmAny(Float value) {
        this(NativeRealmAny.nativeCreateFloat(value.floatValue()));
    }

    public NativeRealmAny(Double value) {
        this(NativeRealmAny.nativeCreateDouble(value));
    }

    public NativeRealmAny(String value) {
        this(NativeRealmAny.nativeCreateString(value));
    }

    public NativeRealmAny(byte[] value) {
        this(NativeRealmAny.nativeCreateBinary(value));
    }

    public NativeRealmAny(Date value) {
        this(NativeRealmAny.nativeCreateDate(value.getTime()));
    }

    public NativeRealmAny(ObjectId value) {
        this(NativeRealmAny.nativeCreateObjectId(value.toString()));
    }

    public NativeRealmAny(Decimal128 value) {
        this(NativeRealmAny.nativeCreateDecimal128(value.getLow(), value.getHigh()));
    }

    public NativeRealmAny(UUID value) {
        this(NativeRealmAny.nativeCreateUUID(value.toString()));
    }

    public NativeRealmAny(RealmObjectProxy model) {
        this(NativeRealmAny.createRealmAnyLink(model));
    }

    private static long createRealmAnyLink(RealmObjectProxy model) {
        Row row$realm = model.realmGet$proxyState().getRow$realm();
        long targetTablePtr = row$realm.getTable().getNativePtr();
        long targetObjectKey = row$realm.getObjectKey();
        return NativeRealmAny.nativeCreateLink(targetTablePtr, targetObjectKey);
    }

    public NativeRealmAny() {
        this(NativeRealmAny.nativeCreateNull());
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public RealmAny.Type getType() {
        return RealmAny.Type.fromNativeValue(NativeRealmAny.nativeGetType(this.nativePtr));
    }

    public boolean asBoolean() {
        return NativeRealmAny.nativeAsBoolean(this.nativePtr);
    }

    public long asLong() {
        return NativeRealmAny.nativeAsLong(this.nativePtr);
    }

    public float asFloat() {
        return NativeRealmAny.nativeAsFloat(this.nativePtr);
    }

    public double asDouble() {
        return NativeRealmAny.nativeAsDouble(this.nativePtr);
    }

    public String asString() {
        return NativeRealmAny.nativeAsString(this.nativePtr);
    }

    public byte[] asBinary() {
        return NativeRealmAny.nativeAsBinary(this.nativePtr);
    }

    public Date asDate() {
        return new Date(NativeRealmAny.nativeAsDate(this.nativePtr));
    }

    public ObjectId asObjectId() {
        return new ObjectId(NativeRealmAny.nativeAsObjectId(this.nativePtr));
    }

    public Decimal128 asDecimal128() {
        long[] data = NativeRealmAny.nativeAsDecimal128(this.nativePtr);
        return Decimal128.fromIEEE754BIDEncoding((long)data[1], (long)data[0]);
    }

    public UUID asUUID() {
        return UUID.fromString(NativeRealmAny.nativeAsUUID(this.nativePtr));
    }

    public <T extends RealmModel> Class<T> getModelClass(OsSharedRealm osSharedRealm, RealmProxyMediator mediator) {
        String className = Table.getClassNameForTable(NativeRealmAny.nativeGetRealmModelTableName(this.nativePtr, osSharedRealm.getNativePtr()));
        return mediator.getClazz(className);
    }

    public String getRealmModelTableName(OsSharedRealm osSharedRealm) {
        return NativeRealmAny.nativeGetRealmModelTableName(this.nativePtr, osSharedRealm.getNativePtr());
    }

    public long getRealmModelRowKey() {
        return NativeRealmAny.nativeGetRealmModelRowKey(this.nativePtr);
    }

    public boolean coercedEquals(NativeRealmAny nativeRealmAny) {
        return NativeRealmAny.nativeEquals(this.nativePtr, nativeRealmAny.nativePtr);
    }

    private static native long nativeCreateNull();

    private static native long nativeCreateBoolean(boolean var0);

    private static native boolean nativeAsBoolean(long var0);

    private static native long nativeCreateLong(long var0);

    private static native long nativeAsLong(long var0);

    private static native long nativeCreateFloat(float var0);

    private static native float nativeAsFloat(long var0);

    private static native long nativeCreateDouble(double var0);

    private static native double nativeAsDouble(long var0);

    private static native long nativeCreateString(String var0);

    private static native String nativeAsString(long var0);

    private static native long nativeCreateBinary(byte[] var0);

    private static native byte[] nativeAsBinary(long var0);

    private static native long nativeCreateDate(long var0);

    private static native long nativeAsDate(long var0);

    private static native long nativeCreateObjectId(String var0);

    private static native String nativeAsObjectId(long var0);

    private static native long nativeCreateDecimal128(long var0, long var2);

    private static native long[] nativeAsDecimal128(long var0);

    private static native long nativeCreateUUID(String var0);

    private static native String nativeAsUUID(long var0);

    private static native long nativeCreateLink(long var0, long var2);

    private static native int nativeGetType(long var0);

    private static native String nativeGetRealmModelTableName(long var0, long var2);

    private static native long nativeGetRealmModelRowKey(long var0);

    private static native boolean nativeEquals(long var0, long var2);

    private static native long nativeGetFinalizerPtr();
}

