/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.OsObjectSchemaInfo;
import io.realm.internal.OsSharedRealm;
import java.util.Collection;

public class OsSchemaInfo
implements NativeObject {
    private long nativePtr;
    private static final long nativeFinalizerPtr = OsSchemaInfo.nativeGetFinalizerPtr();
    private final OsSharedRealm sharedRealm;

    public OsSchemaInfo(Collection<OsObjectSchemaInfo> objectSchemaInfoList) {
        this.nativePtr = OsSchemaInfo.nativeCreateFromList(OsSchemaInfo.convertObjectSchemaInfoListToNativePointerArray(objectSchemaInfoList));
        NativeContext.dummyContext.addReference(this);
        this.sharedRealm = null;
    }

    OsSchemaInfo(long nativePtr, OsSharedRealm sharedRealm) {
        this.nativePtr = nativePtr;
        this.sharedRealm = sharedRealm;
    }

    private static long[] convertObjectSchemaInfoListToNativePointerArray(Collection<OsObjectSchemaInfo> objectSchemaInfoList) {
        long[] schemaNativePointers = new long[objectSchemaInfoList.size()];
        int i = 0;
        for (OsObjectSchemaInfo info : objectSchemaInfoList) {
            schemaNativePointers[i] = info.getNativePtr();
            ++i;
        }
        return schemaNativePointers;
    }

    public OsObjectSchemaInfo getObjectSchemaInfo(String className) {
        return new OsObjectSchemaInfo(OsSchemaInfo.nativeGetObjectSchemaInfo(this.nativePtr, className));
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    private static native long nativeCreateFromList(long[] var0);

    private static native long nativeGetFinalizerPtr();

    private static native long nativeGetObjectSchemaInfo(long var0, String var2);
}

