/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.RealmChangeListener;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.Sort;
import io.realm.internal.CheckedRow;
import io.realm.internal.EmptyLoadChangeSet;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.ObservableCollection;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsCollectionChangeSet;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.UncheckedRow;
import io.realm.internal.objectstore.OsKeyPathMapping;
import io.realm.internal.objectstore.OsObjectBuilder;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class OsResults
implements NativeObject,
ObservableCollection {
    private static final String CLOSED_REALM_MESSAGE = "This Realm instance has already been closed, making it unusable.";
    private final long nativePtr;
    private static final long nativeFinalizerPtr = OsResults.nativeGetFinalizerPtr();
    private final OsSharedRealm sharedRealm;
    private final NativeContext context;
    private final Table table;
    protected boolean loaded;
    private boolean isSnapshot = false;
    protected final ObserverPairList<ObservableCollection.CollectionObserverPair> observerPairs = new ObserverPairList();
    public static final byte AGGREGATE_FUNCTION_MINIMUM = 1;
    public static final byte AGGREGATE_FUNCTION_MAXIMUM = 2;
    public static final byte AGGREGATE_FUNCTION_AVERAGE = 3;
    public static final byte AGGREGATE_FUNCTION_SUM = 4;
    public static final byte MODE_EMPTY = 0;
    public static final byte MODE_TABLE = 1;
    public static final byte MODE_LIST = 2;
    public static final byte MODE_QUERY = 3;
    public static final byte MODE_TABLEVIEW = 4;

    public static OsResults createForBacklinks(OsSharedRealm realm, UncheckedRow row, Table srcTable, String srcFieldName) {
        long backlinksPtr = OsResults.nativeCreateResultsFromBacklinks(realm.getNativePtr(), row.getNativePtr(), srcTable.getNativePtr(), srcTable.getColumnKey(srcFieldName));
        return new OsResults(realm, srcTable, backlinksPtr);
    }

    public static OsResults createFromQuery(OsSharedRealm sharedRealm, TableQuery query) {
        query.validateQuery();
        long ptr = OsResults.nativeCreateResults(sharedRealm.getNativePtr(), query.getNativePtr());
        return new OsResults(sharedRealm, query.getTable(), ptr);
    }

    public static OsResults createFromMap(OsSharedRealm sharedRealm, long resultsPtr) {
        return new OsResults(sharedRealm, resultsPtr);
    }

    OsResults(OsSharedRealm sharedRealm, long nativePtr) {
        this.sharedRealm = sharedRealm;
        this.context = sharedRealm.context;
        this.nativePtr = nativePtr;
        this.context.addReference(this);
        this.loaded = this.getMode() != Mode.QUERY;
        this.table = new Table(sharedRealm, OsResults.nativeGetTable(nativePtr));
    }

    OsResults(OsSharedRealm sharedRealm, Table table, long nativePtr) {
        this.sharedRealm = sharedRealm;
        this.context = sharedRealm.context;
        this.table = table;
        this.nativePtr = nativePtr;
        this.context.addReference(this);
        this.loaded = this.getMode() != Mode.QUERY;
    }

    public OsResults createSnapshot() {
        if (this.isSnapshot) {
            return this;
        }
        OsResults osResults = new OsResults(this.sharedRealm, this.table, OsResults.nativeCreateSnapshot(this.nativePtr));
        osResults.isSnapshot = true;
        return osResults;
    }

    public OsResults freeze(OsSharedRealm frozenRealm) {
        OsResults results = new OsResults(frozenRealm, this.table.freeze(frozenRealm), OsResults.nativeFreeze(this.nativePtr, frozenRealm.getNativePtr()));
        if (this.isLoaded()) {
            results.load();
        }
        return results;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public Object getValue(int index) {
        return OsResults.nativeGetValue(this.nativePtr, index);
    }

    public UncheckedRow getUncheckedRow(int index) {
        return this.table.getUncheckedRowByPointer(OsResults.nativeGetRow(this.nativePtr, index));
    }

    public UncheckedRow firstUncheckedRow() {
        long rowPtr = OsResults.nativeFirstRow(this.nativePtr);
        if (rowPtr != 0L) {
            return this.table.getUncheckedRowByPointer(rowPtr);
        }
        return null;
    }

    public UncheckedRow lastUncheckedRow() {
        long rowPtr = OsResults.nativeLastRow(this.nativePtr);
        if (rowPtr != 0L) {
            return this.table.getUncheckedRowByPointer(rowPtr);
        }
        return null;
    }

    public Table getTable() {
        return this.table;
    }

    public TableQuery where() {
        long nativeQueryPtr = OsResults.nativeWhere(this.nativePtr);
        return new TableQuery(this.context, this.table, nativeQueryPtr);
    }

    public String toJSON(int maxDepth) {
        return OsResults.toJSON(this.nativePtr, maxDepth);
    }

    public Number aggregateNumber(Aggregate aggregateMethod, long columnKey) {
        return (Number)OsResults.nativeAggregate(this.nativePtr, columnKey, aggregateMethod.getValue());
    }

    public Date aggregateDate(Aggregate aggregateMethod, long columnIndex) {
        return (Date)OsResults.nativeAggregate(this.nativePtr, columnIndex, aggregateMethod.getValue());
    }

    public long size() {
        return OsResults.nativeSize(this.nativePtr);
    }

    public void clear() {
        OsResults.nativeClear(this.nativePtr);
    }

    public OsResults sort(@Nullable OsKeyPathMapping mapping, String fieldName, Sort sortOrder) {
        String query = TableQuery.buildSortDescriptor(new String[]{fieldName}, new Sort[]{sortOrder});
        return new OsResults(this.sharedRealm, this.table, OsResults.nativeStringDescriptor(this.nativePtr, query, mapping != null ? mapping.getNativePtr() : 0L));
    }

    public OsResults sort(@Nullable OsKeyPathMapping mapping, String[] fieldNames, Sort[] sortOrders) {
        if (sortOrders == null || sortOrders.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sort order.");
        }
        if (fieldNames.length != sortOrders.length) {
            throw new IllegalArgumentException("Number of fields and sort orders do not match.");
        }
        String query = TableQuery.buildSortDescriptor(fieldNames, sortOrders);
        return new OsResults(this.sharedRealm, this.table, OsResults.nativeStringDescriptor(this.nativePtr, query, mapping != null ? mapping.getNativePtr() : 0L));
    }

    public OsResults distinct(@Nullable OsKeyPathMapping mapping, String[] fieldNames) {
        String query = TableQuery.buildDistinctDescriptor(fieldNames);
        return new OsResults(this.sharedRealm, this.table, OsResults.nativeStringDescriptor(this.nativePtr, query, mapping != null ? mapping.getNativePtr() : 0L));
    }

    public boolean contains(UncheckedRow row) {
        return OsResults.nativeContains(this.nativePtr, row.getNativePtr());
    }

    public int indexOf(UncheckedRow row) {
        long index = OsResults.nativeIndexOf(this.nativePtr, row.getNativePtr());
        return index > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)index;
    }

    public void delete(long index) {
        OsResults.nativeDelete(this.nativePtr, index);
    }

    public boolean deleteFirst() {
        return OsResults.nativeDeleteFirst(this.nativePtr);
    }

    public boolean deleteLast() {
        return OsResults.nativeDeleteLast(this.nativePtr);
    }

    public void setNull(String fieldName) {
        OsResults.nativeSetNull(this.nativePtr, fieldName);
    }

    public void setBoolean(String fieldName, boolean value) {
        OsResults.nativeSetBoolean(this.nativePtr, fieldName, value);
    }

    public void setInt(String fieldName, long value) {
        OsResults.nativeSetInt(this.nativePtr, fieldName, value);
    }

    public void setFloat(String fieldName, float value) {
        OsResults.nativeSetFloat(this.nativePtr, fieldName, value);
    }

    public void setDouble(String fieldName, double value) {
        OsResults.nativeSetDouble(this.nativePtr, fieldName, value);
    }

    public void setString(String fieldName, @Nullable String value) {
        OsResults.nativeSetString(this.nativePtr, fieldName, value);
    }

    public void setBlob(String fieldName, @Nullable byte[] value) {
        OsResults.nativeSetBinary(this.nativePtr, fieldName, value);
    }

    public void setDate(String fieldName, @Nullable Date timestamp) {
        if (timestamp == null) {
            OsResults.nativeSetNull(this.nativePtr, fieldName);
        } else {
            OsResults.nativeSetTimestamp(this.nativePtr, fieldName, timestamp.getTime());
        }
    }

    public void setDecimal128(String fieldName, @Nullable Decimal128 value) {
        if (value == null) {
            OsResults.nativeSetNull(this.nativePtr, fieldName);
        } else {
            OsResults.nativeSetDecimal128(this.nativePtr, fieldName, value.getLow(), value.getHigh());
        }
    }

    public void setObjectId(String fieldName, @Nullable ObjectId value) {
        if (value == null) {
            OsResults.nativeSetNull(this.nativePtr, fieldName);
        } else {
            OsResults.nativeSetObjectId(this.nativePtr, fieldName, value.toString());
        }
    }

    public void setUUID(String fieldName, @Nullable UUID value) {
        if (value == null) {
            OsResults.nativeSetNull(this.nativePtr, fieldName);
        } else {
            OsResults.nativeSetUUID(this.nativePtr, fieldName, value.toString());
        }
    }

    public void setObject(String fieldName, @Nullable Row row) {
        if (row == null) {
            this.setNull(fieldName);
        } else {
            long rowPtr;
            if (row instanceof UncheckedRow) {
                rowPtr = ((UncheckedRow)row).getNativePtr();
            } else if (row instanceof CheckedRow) {
                rowPtr = ((CheckedRow)row).getNativePtr();
            } else {
                throw new UnsupportedOperationException("Unsupported Row type: " + row.getClass().getCanonicalName());
            }
            OsResults.nativeSetObject(this.nativePtr, fieldName, rowPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addTypeSpecificList(String fieldName, RealmList<T> list, AddListTypeDelegate<T> delegate) {
        delegate.addList(builder, list);
        try (OsObjectBuilder builder = new OsObjectBuilder(this.getTable(), Collections.EMPTY_SET);){
            OsResults.nativeSetList(this.nativePtr, fieldName, builder.getNativePtr());
        }
    }

    public void setStringList(String fieldName, RealmList<String> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<String>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<String> list) {
                builder.addStringList(0L, list);
            }
        });
    }

    public void setByteList(String fieldName, RealmList<Byte> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Byte>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Byte> list) {
                builder.addByteList(0L, list);
            }
        });
    }

    public void setShortList(String fieldName, RealmList<Short> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Short>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Short> list) {
                builder.addShortList(0L, list);
            }
        });
    }

    public void setIntegerList(String fieldName, RealmList<Integer> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Integer>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Integer> list) {
                builder.addIntegerList(0L, list);
            }
        });
    }

    public void setLongList(String fieldName, RealmList<Long> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Long>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Long> list) {
                builder.addLongList(0L, list);
            }
        });
    }

    public void setBooleanList(String fieldName, RealmList<Boolean> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Boolean>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Boolean> list) {
                builder.addBooleanList(0L, list);
            }
        });
    }

    public void setByteArrayList(String fieldName, RealmList<byte[]> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<byte[]>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<byte[]> list) {
                builder.addByteArrayList(0L, list);
            }
        });
    }

    public void setDateList(String fieldName, RealmList<Date> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Date>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Date> list) {
                builder.addDateList(0L, list);
            }
        });
    }

    public void setFloatList(String fieldName, RealmList<Float> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Float>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Float> list) {
                builder.addFloatList(0L, list);
            }
        });
    }

    public void setDoubleList(String fieldName, RealmList<Double> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Double>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Double> list) {
                builder.addDoubleList(0L, list);
            }
        });
    }

    public void setModelList(String fieldName, RealmList<RealmModel> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<RealmModel>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<RealmModel> list) {
                builder.addObjectList(0L, list);
            }
        });
    }

    public void setDecimal128List(String fieldName, RealmList<Decimal128> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<Decimal128>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<Decimal128> list) {
                builder.addDecimal128List(0L, list);
            }
        });
    }

    public void setObjectIdList(String fieldName, RealmList<ObjectId> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<ObjectId>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<ObjectId> list) {
                builder.addObjectIdList(0L, list);
            }
        });
    }

    public void setUUIDList(String fieldName, RealmList<UUID> list) {
        this.addTypeSpecificList(fieldName, list, new AddListTypeDelegate<UUID>(){

            @Override
            public void addList(OsObjectBuilder builder, RealmList<UUID> list) {
                builder.addUUIDList(0L, list);
            }
        });
    }

    public <T> void addListener(T observer, OrderedRealmCollectionChangeListener<T> listener) {
        if (this.observerPairs.isEmpty()) {
            this.nativeStartListening(this.nativePtr);
        }
        ObservableCollection.CollectionObserverPair<T> collectionObserverPair = new ObservableCollection.CollectionObserverPair<T>(observer, listener);
        this.observerPairs.add(collectionObserverPair);
    }

    public <T> void addListener(T observer, RealmChangeListener<T> listener) {
        this.addListener(observer, new ObservableCollection.RealmChangeListenerWrapper<T>(listener));
    }

    public <T> void removeListener(T observer, OrderedRealmCollectionChangeListener<T> listener) {
        this.observerPairs.remove(observer, listener);
        if (this.observerPairs.isEmpty()) {
            this.nativeStopListening(this.nativePtr);
        }
    }

    public <T> void removeListener(T observer, RealmChangeListener<T> listener) {
        this.removeListener(observer, new ObservableCollection.RealmChangeListenerWrapper<T>(listener));
    }

    public void removeAllListeners() {
        this.observerPairs.clear();
        this.nativeStopListening(this.nativePtr);
    }

    public boolean isValid() {
        return OsResults.nativeIsValid(this.nativePtr);
    }

    @Override
    public void notifyChangeListeners(long nativeChangeSetPtr) {
        OsCollectionChangeSet changeset;
        OsCollectionChangeSet osCollectionChangeSet = nativeChangeSetPtr == 0L ? new EmptyLoadChangeSet() : (changeset = new OsCollectionChangeSet(nativeChangeSetPtr, !this.isLoaded()));
        if (changeset.isEmpty() && this.isLoaded()) {
            return;
        }
        this.loaded = true;
        this.observerPairs.foreach(new ObservableCollection.Callback(changeset));
    }

    public Mode getMode() {
        return Mode.getByValue(OsResults.nativeGetMode(this.nativePtr));
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        OsResults.nativeEvaluateQueryIfNeeded(this.nativePtr, false);
        this.notifyChangeListeners(0L);
    }

    private static native long nativeGetFinalizerPtr();

    protected static native long nativeCreateResults(long var0, long var2);

    private static native long nativeCreateSnapshot(long var0);

    private static native long nativeFreeze(long var0, long var2);

    private static native long nativeGetRow(long var0, int var2);

    private static native long nativeFirstRow(long var0);

    private static native long nativeLastRow(long var0);

    private static native boolean nativeContains(long var0, long var2);

    private static native void nativeClear(long var0);

    private static native long nativeSize(long var0);

    private static native Object nativeAggregate(long var0, long var2, byte var4);

    private static native long nativeStringDescriptor(long var0, String var2, long var3);

    private static native boolean nativeDeleteFirst(long var0);

    private static native boolean nativeDeleteLast(long var0);

    private static native void nativeDelete(long var0, long var2);

    private static native void nativeSetNull(long var0, String var2);

    private static native void nativeSetBoolean(long var0, String var2, boolean var3);

    private static native void nativeSetInt(long var0, String var2, long var3);

    private static native void nativeSetFloat(long var0, String var2, float var3);

    private static native void nativeSetDouble(long var0, String var2, double var3);

    private static native void nativeSetString(long var0, String var2, @Nullable String var3);

    private static native void nativeSetBinary(long var0, String var2, @Nullable byte[] var3);

    private static native void nativeSetTimestamp(long var0, String var2, long var3);

    private static native void nativeSetDecimal128(long var0, String var2, long var3, long var5);

    private static native void nativeSetObjectId(long var0, String var2, String var3);

    private static native void nativeSetUUID(long var0, String var2, String var3);

    private static native void nativeSetObject(long var0, String var2, long var3);

    private static native void nativeSetList(long var0, String var2, long var3);

    private native void nativeStartListening(long var1);

    private native void nativeStopListening(long var1);

    private static native long nativeGetTable(long var0);

    private static native long nativeWhere(long var0);

    private static native String toJSON(long var0, int var2);

    private static native long nativeIndexOf(long var0, long var2);

    private static native boolean nativeIsValid(long var0);

    private static native byte nativeGetMode(long var0);

    private static native long nativeCreateResultsFromBacklinks(long var0, long var2, long var4, long var6);

    private static native void nativeEvaluateQueryIfNeeded(long var0, boolean var2);

    private static native Object nativeGetValue(long var0, int var2);

    private static interface AddListTypeDelegate<T> {
        public void addList(OsObjectBuilder var1, RealmList<T> var2);
    }

    public static enum Mode {
        EMPTY,
        TABLE,
        PRIMITIVE_LIST,
        QUERY,
        TABLEVIEW;


        static Mode getByValue(byte value) {
            switch (value) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return TABLE;
                }
                case 3: {
                    return QUERY;
                }
                case 2: {
                    return PRIMITIVE_LIST;
                }
                case 4: {
                    return TABLEVIEW;
                }
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum Aggregate {
        MINIMUM(1),
        MAXIMUM(2),
        AVERAGE(3),
        SUM(4);

        private final byte value;

        private Aggregate(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static abstract class ListIterator<T>
    extends Iterator<T>
    implements java.util.ListIterator<T> {
        public ListIterator(OsResults osResults, int start) {
            super(osResults);
            if (start < 0 || (long)start > this.iteratorOsResults.size()) {
                throw new IndexOutOfBoundsException("Starting location must be a valid index: [0, " + (this.iteratorOsResults.size() - 1L) + "]. Yours was " + start);
            }
            this.pos = start - 1;
        }

        @Override
        @Deprecated
        public void add(@Nullable T object) {
            throw new UnsupportedOperationException("Adding an element is not supported. Use Realm.createObject() instead.");
        }

        @Override
        public boolean hasPrevious() {
            this.checkValid();
            return this.pos >= 0;
        }

        @Override
        public int nextIndex() {
            this.checkValid();
            return this.pos + 1;
        }

        @Override
        @Nullable
        public T previous() {
            this.checkValid();
            try {
                Object obj = this.get(this.pos);
                --this.pos;
                return obj;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("Cannot access index less than zero. This was " + this.pos + ". Remember to check hasPrevious() before using previous().");
            }
        }

        @Override
        public int previousIndex() {
            this.checkValid();
            return this.pos;
        }

        @Override
        @Deprecated
        public void set(@Nullable T object) {
            throw new UnsupportedOperationException("Replacing an element is not supported.");
        }
    }

    public static abstract class Iterator<T>
    implements java.util.Iterator<T> {
        protected OsResults iteratorOsResults;
        protected int pos = -1;

        public Iterator(OsResults osResults) {
            if (osResults.sharedRealm.isClosed()) {
                throw new IllegalStateException(OsResults.CLOSED_REALM_MESSAGE);
            }
            this.iteratorOsResults = osResults;
            if (osResults.isSnapshot) {
                return;
            }
            if (osResults.sharedRealm.isInTransaction()) {
                this.detach();
            } else {
                this.iteratorOsResults.sharedRealm.addIterator(this);
            }
        }

        @Override
        public boolean hasNext() {
            this.checkValid();
            return (long)(this.pos + 1) < this.iteratorOsResults.size();
        }

        @Override
        @Nullable
        public T next() {
            this.checkValid();
            ++this.pos;
            if ((long)this.pos >= this.iteratorOsResults.size()) {
                throw new NoSuchElementException("Cannot access index " + this.pos + " when size is " + this.iteratorOsResults.size() + ". Remember to check hasNext() before using next().");
            }
            return this.get(this.pos);
        }

        @Override
        @Deprecated
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported by RealmResults iterators.");
        }

        void detach() {
            this.iteratorOsResults = this.iteratorOsResults.createSnapshot();
        }

        void invalidate() {
            this.iteratorOsResults = null;
        }

        void checkValid() {
            if (this.iteratorOsResults == null) {
                throw new ConcurrentModificationException("No outside changes to a Realm is allowed while iterating a living Realm collection.");
            }
        }

        @Nullable
        T get(int pos) {
            return this.getInternal(pos, this.iteratorOsResults);
        }

        protected abstract T convertRowToObject(UncheckedRow var1);

        protected abstract T getInternal(int var1, OsResults var2);
    }
}

