/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.BinaryOperator;
import io.realm.BooleanOperator;
import io.realm.ByteOperator;
import io.realm.CollectionUtils;
import io.realm.DateOperator;
import io.realm.Decimal128Operator;
import io.realm.DoubleOperator;
import io.realm.DynamicSetOperator;
import io.realm.FloatOperator;
import io.realm.IntegerOperator;
import io.realm.LongOperator;
import io.realm.NumberOperator;
import io.realm.ObjectIdOperator;
import io.realm.RealmAny;
import io.realm.RealmAnySetOperator;
import io.realm.RealmChangeListener;
import io.realm.RealmCollection;
import io.realm.RealmModelSetOperator;
import io.realm.RealmQuery;
import io.realm.SetChangeListener;
import io.realm.SetValueOperator;
import io.realm.ShortOperator;
import io.realm.StringOperator;
import io.realm.UUIDOperator;
import io.realm.internal.ManageableObject;
import io.realm.internal.OsSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class RealmSet<E>
implements Set<E>,
ManageableObject,
RealmCollection<E> {
    protected final SetStrategy<E> setStrategy;

    public RealmSet() {
        this.setStrategy = new UnmanagedSetStrategy();
    }

    public RealmSet(Collection<E> collection) {
        this.setStrategy = new UnmanagedSetStrategy<E>(collection);
    }

    public RealmSet(BaseRealm baseRealm, OsSet osSet, Class<E> valueClass) {
        this.setStrategy = RealmSet.getStrategy(baseRealm, osSet, valueClass);
    }

    public RealmSet(BaseRealm baseRealm, OsSet osSet, String className) {
        this.setStrategy = RealmSet.getStrategy(baseRealm, osSet, className);
    }

    @Override
    public boolean isManaged() {
        return this.setStrategy.isManaged();
    }

    @Override
    public boolean isValid() {
        return this.setStrategy.isValid();
    }

    @Override
    public boolean isFrozen() {
        return this.setStrategy.isFrozen();
    }

    @Override
    public int size() {
        return this.setStrategy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.setStrategy.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.setStrategy.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.setStrategy.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.setStrategy.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.setStrategy.toArray(a);
    }

    @Override
    public boolean add(@Nullable E e) {
        return this.setStrategy.add(e);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.setStrategy.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.setStrategy.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.setStrategy.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.setStrategy.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.setStrategy.removeAll(c);
    }

    @Override
    public void clear() {
        this.setStrategy.clear();
    }

    @Override
    public RealmSet<E> freeze() {
        return this.setStrategy.freeze();
    }

    public void addChangeListener(RealmChangeListener<RealmSet<E>> listener) {
        this.setStrategy.addChangeListener(this, listener);
    }

    public void addChangeListener(SetChangeListener<E> listener) {
        this.setStrategy.addChangeListener(this, listener);
    }

    public void removeChangeListener(RealmChangeListener<RealmSet<E>> listener) {
        this.setStrategy.removeChangeListener(this, listener);
    }

    public void removeChangeListener(SetChangeListener<E> listener) {
        this.setStrategy.removeChangeListener(this, listener);
    }

    public void removeAllChangeListeners() {
        this.setStrategy.removeAllChangeListeners();
    }

    @Override
    public RealmQuery<E> where() {
        return this.setStrategy.where();
    }

    @Override
    @Nullable
    public Number min(String fieldName) {
        return this.setStrategy.min(fieldName);
    }

    @Override
    @Nullable
    public Number max(String fieldName) {
        return this.setStrategy.max(fieldName);
    }

    @Override
    public Number sum(String fieldName) {
        return this.setStrategy.sum(fieldName);
    }

    @Override
    public double average(String fieldName) {
        return this.setStrategy.average(fieldName);
    }

    @Override
    @Nullable
    public Date maxDate(String fieldName) {
        return this.setStrategy.maxDate(fieldName);
    }

    @Override
    @Nullable
    public Date minDate(String fieldName) {
        return this.setStrategy.minDate(fieldName);
    }

    @Override
    public boolean deleteAllFromRealm() {
        return this.setStrategy.deleteAllFromRealm();
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean load() {
        return true;
    }

    OsSet getOsSet() {
        return this.setStrategy.getOsSet();
    }

    boolean hasListeners() {
        return this.setStrategy.hasListeners();
    }

    private static <T> ManagedSetStrategy<T> getStrategy(BaseRealm baseRealm, OsSet osSet, Class<T> valueClass) {
        SetValueOperator operator;
        if (CollectionUtils.isClassForRealmModel(valueClass)) {
            Class<T> typeCastClass = valueClass;
            return new ManagedSetStrategy<T>(new RealmModelSetOperator<T>(baseRealm, osSet, typeCastClass), valueClass);
        }
        if (valueClass == Boolean.class) {
            operator = new BooleanOperator(baseRealm, osSet, Boolean.class);
        } else if (valueClass == String.class) {
            operator = new StringOperator(baseRealm, osSet, String.class);
        } else if (valueClass == Integer.class) {
            operator = new IntegerOperator(baseRealm, osSet, Integer.class);
        } else if (valueClass == Long.class) {
            operator = new LongOperator(baseRealm, osSet, Long.class);
        } else if (valueClass == Short.class) {
            operator = new ShortOperator(baseRealm, osSet, Short.class);
        } else if (valueClass == Byte.class) {
            operator = new ByteOperator(baseRealm, osSet, Byte.class);
        } else if (valueClass == Float.class) {
            operator = new FloatOperator(baseRealm, osSet, Float.class);
        } else if (valueClass == Double.class) {
            operator = new DoubleOperator(baseRealm, osSet, Double.class);
        } else if (valueClass == byte[].class) {
            operator = new BinaryOperator(baseRealm, osSet, byte[].class);
        } else if (valueClass == Date.class) {
            operator = new DateOperator(baseRealm, osSet, Date.class);
        } else if (valueClass == Decimal128.class) {
            operator = new Decimal128Operator(baseRealm, osSet, Decimal128.class);
        } else if (valueClass == ObjectId.class) {
            operator = new ObjectIdOperator(baseRealm, osSet, ObjectId.class);
        } else if (valueClass == UUID.class) {
            operator = new UUIDOperator(baseRealm, osSet, UUID.class);
        } else if (valueClass == RealmAny.class) {
            operator = new RealmAnySetOperator(baseRealm, osSet, RealmAny.class);
        } else if (valueClass == Number.class) {
            operator = new NumberOperator(baseRealm, osSet, Number.class);
        } else {
            throw new UnsupportedOperationException("getStrategy: missing class '" + valueClass.getSimpleName() + "'");
        }
        return new ManagedSetStrategy<Boolean>(operator, valueClass);
    }

    private static <T> ManagedSetStrategy<T> getStrategy(BaseRealm baseRealm, OsSet osSet, String className) {
        SetValueOperator operator = className.equals(Boolean.class.getCanonicalName()) ? new BooleanOperator(baseRealm, osSet, Boolean.class) : (className.equals(String.class.getCanonicalName()) ? new StringOperator(baseRealm, osSet, String.class) : (className.equals(Integer.class.getCanonicalName()) ? new IntegerOperator(baseRealm, osSet, Integer.class) : (className.equals(Long.class.getCanonicalName()) ? new LongOperator(baseRealm, osSet, Long.class) : (className.equals(Short.class.getCanonicalName()) ? new ShortOperator(baseRealm, osSet, Short.class) : (className.equals(Byte.class.getCanonicalName()) ? new ByteOperator(baseRealm, osSet, Byte.class) : (className.equals(Float.class.getCanonicalName()) ? new FloatOperator(baseRealm, osSet, Float.class) : (className.equals(Double.class.getCanonicalName()) ? new DoubleOperator(baseRealm, osSet, Double.class) : (className.equals(byte[].class.getCanonicalName()) ? new BinaryOperator(baseRealm, osSet, byte[].class) : (className.equals(Date.class.getCanonicalName()) ? new DateOperator(baseRealm, osSet, Date.class) : (className.equals(Decimal128.class.getCanonicalName()) ? new Decimal128Operator(baseRealm, osSet, Decimal128.class) : (className.equals(ObjectId.class.getCanonicalName()) ? new ObjectIdOperator(baseRealm, osSet, ObjectId.class) : (className.equals(UUID.class.getCanonicalName()) ? new UUIDOperator(baseRealm, osSet, UUID.class) : (className.equals(RealmAny.class.getCanonicalName()) ? new RealmAnySetOperator(baseRealm, osSet, RealmAny.class) : new DynamicSetOperator(baseRealm, osSet, className))))))))))))));
        return new ManagedSetStrategy<Boolean>(operator, operator.getValueClass());
    }

    public String getValueClassName() {
        return this.setStrategy.getValueClassName();
    }

    public Class<E> getValueClass() {
        return this.setStrategy.getValueClass();
    }

    private static class UnmanagedSetStrategy<E>
    extends SetStrategy<E> {
        private static final String ONLY_IN_MANAGED_MODE_MESSAGE = "This method is only available in managed mode.";
        private final Set<E> unmanagedSet = new HashSet();

        UnmanagedSetStrategy() {
        }

        UnmanagedSetStrategy(Collection<E> collection) {
            this();
            this.unmanagedSet.addAll(collection);
        }

        @Override
        public boolean isManaged() {
            return false;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        @Override
        public RealmQuery<E> where() {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }

        @Override
        @Nullable
        public Number min(String fieldName) {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }

        @Override
        @Nullable
        public Number max(String fieldName) {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }

        @Override
        public Number sum(String fieldName) {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }

        @Override
        public double average(String fieldName) {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }

        @Override
        @Nullable
        public Date maxDate(String fieldName) {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }

        @Override
        @Nullable
        public Date minDate(String fieldName) {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }

        @Override
        public boolean deleteAllFromRealm() {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }

        @Override
        public boolean isLoaded() {
            return true;
        }

        @Override
        public boolean load() {
            return true;
        }

        @Override
        public int size() {
            return this.unmanagedSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.unmanagedSet.isEmpty();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            return this.unmanagedSet.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.unmanagedSet.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.unmanagedSet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.unmanagedSet.toArray(a);
        }

        @Override
        public boolean add(@Nullable E e) {
            return this.unmanagedSet.add(e);
        }

        @Override
        public boolean remove(@Nullable Object o) {
            return this.unmanagedSet.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.unmanagedSet.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.unmanagedSet.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.unmanagedSet.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.unmanagedSet.removeAll(c);
        }

        @Override
        public void clear() {
            this.unmanagedSet.clear();
        }

        @Override
        public RealmSet<E> freeze() {
            throw new UnsupportedOperationException("Unmanaged RealmSets cannot be frozen.");
        }

        @Override
        public String getValueClassName() {
            throw new UnsupportedOperationException("Unmanaged sets do not support retrieving the value class name.");
        }

        @Override
        public Class<E> getValueClass() {
            throw new UnsupportedOperationException("Unmanaged sets do not support retrieving the value class.");
        }

        @Override
        OsSet getOsSet() {
            throw new UnsupportedOperationException("Unmanaged RealmSets do not have a representation in native code.");
        }

        @Override
        void addChangeListener(RealmSet<E> set, RealmChangeListener<RealmSet<E>> listener) {
            throw new UnsupportedOperationException("Unmanaged RealmSets do not support change listeners.");
        }

        @Override
        void addChangeListener(RealmSet<E> set, SetChangeListener<E> listener) {
            throw new UnsupportedOperationException("Unmanaged RealmSets do not support change listeners.");
        }

        @Override
        void removeChangeListener(RealmSet<E> set, RealmChangeListener<RealmSet<E>> listener) {
            throw new UnsupportedOperationException("Cannot remove change listener because unmanaged RealmSets do not support change listeners.");
        }

        @Override
        void removeChangeListener(RealmSet<E> set, SetChangeListener<E> listener) {
            throw new UnsupportedOperationException("Cannot remove change listener because unmanaged RealmSets do not support change listeners.");
        }

        @Override
        void removeAllChangeListeners() {
            throw new UnsupportedOperationException("Cannot remove change listeners because unmanaged RealmSets do not support change listeners.");
        }

        @Override
        boolean hasListeners() {
            return false;
        }
    }

    private static class ManagedSetStrategy<E>
    extends SetStrategy<E> {
        private final SetValueOperator<E> setValueOperator;
        private Class<E> valueClass;

        ManagedSetStrategy(SetValueOperator<E> setValueOperator, Class<E> valueClass) {
            this.setValueOperator = setValueOperator;
            this.valueClass = valueClass;
        }

        @Override
        public boolean isManaged() {
            return true;
        }

        @Override
        public RealmQuery<E> where() {
            return this.setValueOperator.where();
        }

        @Override
        @Nullable
        public Number min(String fieldName) {
            return this.where().min(fieldName);
        }

        @Override
        @Nullable
        public Number max(String fieldName) {
            return this.where().max(fieldName);
        }

        @Override
        public Number sum(String fieldName) {
            return this.where().sum(fieldName);
        }

        @Override
        public double average(String fieldName) {
            return this.where().average(fieldName);
        }

        @Override
        @Nullable
        public Date maxDate(String fieldName) {
            return this.where().maximumDate(fieldName);
        }

        @Override
        @Nullable
        public Date minDate(String fieldName) {
            return this.where().minimumDate(fieldName);
        }

        @Override
        public boolean deleteAllFromRealm() {
            this.setValueOperator.baseRealm.checkIfValid();
            if (!this.setValueOperator.isEmpty()) {
                this.setValueOperator.deleteAll();
                return true;
            }
            return false;
        }

        @Override
        public boolean isLoaded() {
            return true;
        }

        @Override
        public boolean load() {
            return true;
        }

        @Override
        public boolean isValid() {
            return this.setValueOperator.isValid();
        }

        @Override
        public boolean isFrozen() {
            return this.setValueOperator.isFrozen();
        }

        @Override
        public int size() {
            return this.setValueOperator.size();
        }

        @Override
        public boolean isEmpty() {
            return this.setValueOperator.isEmpty();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            return this.setValueOperator.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.setValueOperator.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            int i = 0;
            for (E value : this) {
                array[i] = value;
                ++i;
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.checkValidArray(a);
            long setSize = this.size();
            Object[] array = (long)a.length == setSize || (long)a.length > setSize ? a : (Object[])Array.newInstance(this.valueClass, (int)setSize);
            int i = 0;
            for (E value : this) {
                array[i] = value == null ? null : value;
                ++i;
            }
            if ((long)a.length > setSize) {
                array[i] = null;
            }
            return array;
        }

        @Override
        public boolean add(@Nullable E e) {
            return this.setValueOperator.add(e);
        }

        @Override
        public boolean remove(@Nullable Object o) {
            return this.setValueOperator.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            this.checkValidCollection(c);
            return this.setValueOperator.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.checkValidCollection(c);
            return this.setValueOperator.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.checkValidCollection(c);
            return this.setValueOperator.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.checkValidCollection(c);
            return this.setValueOperator.removeAll(c);
        }

        @Override
        public void clear() {
            this.setValueOperator.clear();
        }

        @Override
        public RealmSet<E> freeze() {
            return this.setValueOperator.freeze();
        }

        @Override
        OsSet getOsSet() {
            return this.setValueOperator.getOsSet();
        }

        @Override
        void addChangeListener(RealmSet<E> set, RealmChangeListener<RealmSet<E>> listener) {
            this.setValueOperator.addChangeListener(set, listener);
        }

        @Override
        void addChangeListener(RealmSet<E> set, SetChangeListener<E> listener) {
            this.setValueOperator.addChangeListener(set, listener);
        }

        @Override
        void removeChangeListener(RealmSet<E> set, RealmChangeListener<RealmSet<E>> listener) {
            this.setValueOperator.removeChangeListener(set, listener);
        }

        @Override
        void removeChangeListener(RealmSet<E> set, SetChangeListener<E> listener) {
            this.setValueOperator.removeChangeListener(set, listener);
        }

        @Override
        void removeAllChangeListeners() {
            this.setValueOperator.removeAllChangeListeners();
        }

        @Override
        boolean hasListeners() {
            return this.setValueOperator.hasListeners();
        }

        private <T> void checkValidArray(T[] array) {
            String arrayTypeSimpleName;
            if (array == null) {
                throw new NullPointerException("Cannot pass a null array when calling 'toArray'.");
            }
            String valueClassSimpleName = this.valueClass.getSimpleName();
            if (!valueClassSimpleName.equals(arrayTypeSimpleName = array.getClass().getComponentType().getSimpleName())) {
                throw new ArrayStoreException("Array type must be of type '" + valueClassSimpleName + "' but it was of type '" + arrayTypeSimpleName + "'.");
            }
        }

        private void checkValidCollection(Collection<?> collection) {
            if (collection == null) {
                throw new NullPointerException("Collection must not be null.");
            }
        }

        @Override
        public String getValueClassName() {
            return this.setValueOperator.getValueClassName();
        }

        @Override
        public Class<E> getValueClass() {
            return this.setValueOperator.getValueClass();
        }
    }

    private static abstract class SetStrategy<E>
    implements Set<E>,
    ManageableObject,
    RealmCollection<E> {
        private SetStrategy() {
        }

        abstract OsSet getOsSet();

        abstract void addChangeListener(RealmSet<E> var1, RealmChangeListener<RealmSet<E>> var2);

        abstract void addChangeListener(RealmSet<E> var1, SetChangeListener<E> var2);

        abstract void removeChangeListener(RealmSet<E> var1, RealmChangeListener<RealmSet<E>> var2);

        abstract void removeChangeListener(RealmSet<E> var1, SetChangeListener<E> var2);

        abstract void removeAllChangeListeners();

        abstract boolean hasListeners();

        @Override
        public abstract RealmSet<E> freeze();

        abstract String getValueClassName();

        abstract Class<E> getValueClass();
    }
}

