/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.MapValueOperator;
import io.realm.RealmMapEntrySet;
import io.realm.RealmModel;
import io.realm.TypeSelectorForMap;
import io.realm.internal.OsMap;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class RealmModelValueOperator<K, V>
extends MapValueOperator<K, V> {
    RealmModelValueOperator(BaseRealm baseRealm, OsMap osMap, TypeSelectorForMap<K, V> typeSelectorForMap) {
        super(RealmModel.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.OBJECT);
    }

    @Override
    @Nullable
    V get(Object key) {
        long realmModelKey = this.osMap.getModelRowKey(key);
        if (realmModelKey == -1L) {
            return null;
        }
        return this.typeSelectorForMap.getRealmModel(this.baseRealm, realmModelKey);
    }

    @Override
    @Nullable
    V put(K key, @Nullable V value) {
        return this.typeSelectorForMap.putRealmModel(this.baseRealm, this.osMap, key, value);
    }

    @Override
    Set<Map.Entry<K, V>> entrySet() {
        return new RealmMapEntrySet(this.baseRealm, this.osMap, RealmMapEntrySet.IteratorType.OBJECT, this.typeSelectorForMap);
    }

    @Override
    boolean containsValueInternal(@Nullable Object value) {
        if (value == null) {
            return this.osMap.containsPrimitiveValue(null);
        }
        if (value instanceof RealmObjectProxy) {
            Row row$realm = ((RealmObjectProxy)value).realmGet$proxyState().getRow$realm();
            long tablePtr = row$realm.getTable().getNativePtr();
            return this.osMap.containsRealmModel(row$realm.getObjectKey(), tablePtr);
        }
        throw new IllegalArgumentException("Only managed models can be contained in this dictionary.");
    }

    @Override
    boolean containsValue(@Nullable Object value) {
        if (value != null && !RealmModel.class.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("Only RealmModel values can be used with 'containsValue'.");
        }
        return this.containsValueInternal(value);
    }
}

