/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.DynamicRealmObject;
import io.realm.ManagedListOperator;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.internal.OsList;
import io.realm.internal.RealmObjectProxy;
import java.util.Locale;
import javax.annotation.Nullable;

final class RealmModelListOperator<T>
extends ManagedListOperator<T> {
    @Nullable
    private final String className;

    RealmModelListOperator(BaseRealm realm, OsList osList, @Nullable Class<T> clazz, @Nullable String className) {
        super(realm, osList, clazz);
        this.className = className;
    }

    @Override
    public boolean forRealmModel() {
        return true;
    }

    @Override
    public T get(int index) {
        return (T)this.realm.get(this.clazz, this.className, this.osList.getUncheckedRow(index));
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("RealmList does not accept null values.");
        }
        if (!(value instanceof RealmModel)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.lang.String", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        RealmModel realmObject = (RealmModel)value;
        boolean copyObject = CollectionUtils.checkCanObjectBeCopied(this.realm, realmObject, this.className, "list");
        if (CollectionUtils.isEmbedded(this.realm, realmObject)) {
            if (value instanceof DynamicRealmObject) {
                throw new IllegalArgumentException("Embedded objects are not supported by RealmLists of DynamicRealmObjects yet.");
            }
            long objKey = this.osList.createAndAddEmbeddedObject();
            CollectionUtils.updateEmbeddedObject((Realm)this.realm, realmObject, objKey);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)(copyObject ? CollectionUtils.copyToRealm(this.realm, (RealmModel)value) : realmObject);
            this.osList.addRow(proxy.realmGet$proxyState().getRow$realm().getObjectKey());
        }
    }

    @Override
    protected void insertNull(int index) {
        throw new RuntimeException("Should not reach here.");
    }

    @Override
    public void insertValue(int index, Object value) {
        this.checkInsertIndex(index);
        RealmModel realmObject = (RealmModel)value;
        boolean copyObject = CollectionUtils.checkCanObjectBeCopied(this.realm, realmObject, this.className, "list");
        if (CollectionUtils.isEmbedded(this.realm, realmObject)) {
            if (value instanceof DynamicRealmObject) {
                throw new IllegalArgumentException("Embedded objects are not supported by RealmLists of DynamicRealmObjects yet.");
            }
            long objKey = this.osList.createAndAddEmbeddedObject(index);
            CollectionUtils.updateEmbeddedObject((Realm)this.realm, realmObject, objKey);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)(copyObject ? CollectionUtils.copyToRealm(this.realm, (RealmModel)value) : realmObject);
            this.osList.insertRow(index, proxy.realmGet$proxyState().getRow$realm().getObjectKey());
        }
    }

    @Override
    protected void setNull(int index) {
        throw new RuntimeException("Should not reach here.");
    }

    @Override
    protected void setValue(int index, Object value) {
        RealmModel realmObject = (RealmModel)value;
        boolean copyObject = CollectionUtils.checkCanObjectBeCopied(this.realm, realmObject, this.className, "list");
        if (CollectionUtils.isEmbedded(this.realm, realmObject)) {
            if (value instanceof DynamicRealmObject) {
                throw new IllegalArgumentException("Embedded objects are not supported by RealmLists of DynamicRealmObjects yet.");
            }
            long objKey = this.osList.createAndSetEmbeddedObject(index);
            CollectionUtils.updateEmbeddedObject((Realm)this.realm, realmObject, objKey);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)(copyObject ? CollectionUtils.copyToRealm(this.realm, (RealmModel)value) : realmObject);
            this.osList.setRow(index, proxy.realmGet$proxyState().getRow$realm().getObjectKey());
        }
    }
}

