/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.RealmAny;
import io.realm.internal.Keep;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@Keep
public enum RealmFieldType {
    INTEGER(0),
    BOOLEAN(1),
    STRING(2),
    BINARY(4),
    DATE(8),
    FLOAT(9),
    DOUBLE(10),
    OBJECT(12),
    DECIMAL128(11),
    OBJECT_ID(15),
    UUID(17),
    MIXED(6),
    TYPED_LINK(16),
    LIST(13),
    LINKING_OBJECTS(14),
    INTEGER_LIST(128),
    BOOLEAN_LIST(129),
    STRING_LIST(130),
    BINARY_LIST(132),
    DATE_LIST(136),
    FLOAT_LIST(137),
    DOUBLE_LIST(138),
    DECIMAL128_LIST(139),
    OBJECT_ID_LIST(143),
    UUID_LIST(145),
    MIXED_LIST(134),
    STRING_TO_INTEGER_MAP(512),
    STRING_TO_BOOLEAN_MAP(513),
    STRING_TO_STRING_MAP(514),
    STRING_TO_BINARY_MAP(516),
    STRING_TO_DATE_MAP(520),
    STRING_TO_FLOAT_MAP(521),
    STRING_TO_DOUBLE_MAP(522),
    STRING_TO_DECIMAL128_MAP(523),
    STRING_TO_OBJECT_ID_MAP(527),
    STRING_TO_UUID_MAP(529),
    STRING_TO_MIXED_MAP(518),
    STRING_TO_LINK_MAP(524),
    INTEGER_SET(256),
    BOOLEAN_SET(257),
    STRING_SET(258),
    BINARY_SET(260),
    DATE_SET(264),
    FLOAT_SET(265),
    DOUBLE_SET(266),
    DECIMAL128_SET(267),
    OBJECT_ID_SET(271),
    UUID_SET(273),
    LINK_SET(268),
    MIXED_SET(262);

    private static final RealmFieldType[] basicTypes;
    private static final RealmFieldType[] listTypes;
    private static final RealmFieldType[] mapTypes;
    private static final RealmFieldType[] setTypes;
    private final int nativeValue;

    private RealmFieldType(int nativeValue) {
        this.nativeValue = nativeValue;
    }

    public int getNativeValue() {
        return this.nativeValue;
    }

    public boolean isValid(Object obj) {
        switch (this.nativeValue) {
            case 0: {
                return obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte;
            }
            case 1: {
                return obj instanceof Boolean;
            }
            case 2: {
                return obj instanceof String;
            }
            case 4: {
                return obj instanceof byte[] || obj instanceof ByteBuffer;
            }
            case 8: {
                return obj instanceof Date;
            }
            case 9: {
                return obj instanceof Float;
            }
            case 10: {
                return obj instanceof Double;
            }
            case 11: {
                return obj instanceof Decimal128;
            }
            case 15: {
                return obj instanceof ObjectId;
            }
            case 17: {
                return obj instanceof UUID;
            }
            case 6: {
                return obj instanceof RealmAny;
            }
            case 12: 
            case 13: 
            case 14: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 145: {
                return false;
            }
            case 512: 
            case 513: 
            case 514: 
            case 516: 
            case 518: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 527: 
            case 529: {
                return false;
            }
            case 256: 
            case 257: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 271: 
            case 273: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported Realm type:  " + (Object)((Object)this));
    }

    public static RealmFieldType fromNativeValue(int value) {
        RealmFieldType e;
        int elementValue;
        RealmFieldType e2;
        if (0 <= value && value < basicTypes.length && (e2 = basicTypes[value]) != null) {
            return e2;
        }
        if (128 <= value && value < 256 && (elementValue = value - 128) < listTypes.length && (e = listTypes[elementValue]) != null) {
            return e;
        }
        if (256 <= value && value < 512 && (elementValue = value - 256) < setTypes.length && (e = setTypes[elementValue]) != null) {
            return e;
        }
        if (512 <= value && (elementValue = value - 512) < mapTypes.length && (e = mapTypes[elementValue]) != null) {
            return e;
        }
        throw new IllegalArgumentException("Invalid native Realm type: " + value);
    }

    static {
        basicTypes = new RealmFieldType[18];
        listTypes = new RealmFieldType[18];
        mapTypes = new RealmFieldType[18];
        setTypes = new RealmFieldType[18];
        for (RealmFieldType columnType : RealmFieldType.values()) {
            int nativeValue = columnType.nativeValue;
            if (nativeValue < 128) {
                RealmFieldType.basicTypes[nativeValue] = columnType;
                continue;
            }
            if (nativeValue < 256) {
                RealmFieldType.listTypes[nativeValue - 128] = columnType;
                continue;
            }
            if (nativeValue < 512) {
                RealmFieldType.setTypes[nativeValue - 256] = columnType;
                continue;
            }
            RealmFieldType.mapTypes[nativeValue - 512] = columnType;
        }
    }
}

