/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.BinaryEquals;
import io.realm.ByteValueOperator;
import io.realm.CollectionUtils;
import io.realm.DictionaryManager;
import io.realm.DynamicSelectorForMap;
import io.realm.GenericPrimitiveValueOperator;
import io.realm.IntegerValueOperator;
import io.realm.LinkSelectorForMap;
import io.realm.MapValueOperator;
import io.realm.RealmAny;
import io.realm.RealmAnyValueOperator;
import io.realm.RealmMap;
import io.realm.RealmMapEntrySet;
import io.realm.RealmModel;
import io.realm.RealmModelValueOperator;
import io.realm.SelectorForMap;
import io.realm.ShortValueOperator;
import io.realm.internal.OsMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class RealmDictionary<V>
extends RealmMap<String, V> {
    public RealmDictionary() {
    }

    public RealmDictionary(Map<String, V> map) {
        super(map);
    }

    RealmDictionary(BaseRealm baseRealm, OsMap osMap, Class<V> valueClass) {
        super(RealmDictionary.getStrategy(valueClass, baseRealm, osMap));
    }

    RealmDictionary(BaseRealm baseRealm, OsMap osMap, String className) {
        super(RealmDictionary.getStrategy(className, baseRealm, osMap));
    }

    private Map<String, V> toMap() {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        return map;
    }

    private static <V extends RealmModel> LinkSelectorForMap<String, V> getRealmSelector(Class<V> valueClass, BaseRealm baseRealm, OsMap osMap) {
        return new LinkSelectorForMap<String, V>(baseRealm, osMap, String.class, valueClass);
    }

    private static <V> RealmMap.ManagedMapStrategy<String, V> getStrategy(Class<V> valueClass, BaseRealm baseRealm, OsMap osMap) {
        if (CollectionUtils.isClassForRealmModel(valueClass)) {
            Class<V> typeCastClass = valueClass;
            LinkSelectorForMap<String, V> realmSelector = RealmDictionary.getRealmSelector(typeCastClass, baseRealm, osMap);
            DictionaryManager<V> dictionaryManager = new DictionaryManager<V>(baseRealm, new RealmModelValueOperator<String, V>(baseRealm, osMap, realmSelector), realmSelector);
            return new RealmMap.ManagedMapStrategy(dictionaryManager);
        }
        DictionaryManager<V> manager = RealmDictionary.getManager(valueClass, baseRealm, osMap);
        return new RealmMap.ManagedMapStrategy(manager);
    }

    private static <V> RealmMap.ManagedMapStrategy<String, V> getStrategy(String valueClass, BaseRealm baseRealm, OsMap osMap) {
        DictionaryManager<V> manager = RealmDictionary.getManager(valueClass, baseRealm, osMap);
        return new RealmMap.ManagedMapStrategy(manager);
    }

    private static <V> DictionaryManager<V> getManager(Class<V> valueClass, BaseRealm baseRealm, OsMap osMap) {
        MapValueOperator mapValueOperator;
        SelectorForMap<String, V> typeSelectorForMap = new SelectorForMap<String, V>(baseRealm, osMap, String.class, valueClass);
        if (valueClass == RealmAny.class) {
            mapValueOperator = new RealmAnyValueOperator<String>(baseRealm, osMap, typeSelectorForMap);
        } else if (valueClass == Long.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, Long>(Long.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.LONG);
        } else if (valueClass == Float.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, Float>(Float.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.FLOAT);
        } else if (valueClass == Double.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, Double>(Double.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.DOUBLE);
        } else if (valueClass == String.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, String>(String.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.STRING);
        } else if (valueClass == Boolean.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, Boolean>(Boolean.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.BOOLEAN);
        } else if (valueClass == Date.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, Date>(Date.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.DATE);
        } else if (valueClass == Decimal128.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, Decimal128>(Decimal128.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.DECIMAL128);
        } else if (valueClass == Integer.class) {
            mapValueOperator = new IntegerValueOperator<String>(baseRealm, osMap, typeSelectorForMap);
        } else if (valueClass == Short.class) {
            mapValueOperator = new ShortValueOperator<String>(baseRealm, osMap, typeSelectorForMap);
        } else if (valueClass == Byte.class) {
            mapValueOperator = new ByteValueOperator<String>(baseRealm, osMap, typeSelectorForMap);
        } else if (valueClass == byte[].class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, byte[]>(byte[].class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.BINARY, new BinaryEquals());
        } else if (valueClass == ObjectId.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, ObjectId>(ObjectId.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.OBJECT_ID);
        } else if (valueClass == UUID.class) {
            mapValueOperator = new GenericPrimitiveValueOperator<String, UUID>(UUID.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.UUID);
        } else {
            throw new IllegalArgumentException("Only Maps of RealmAny or one of the types that can be boxed inside RealmAny can be used.");
        }
        return new DictionaryManager<V>(baseRealm, mapValueOperator, typeSelectorForMap);
    }

    private static <V> DictionaryManager<V> getManager(String valueClass, BaseRealm baseRealm, OsMap osMap) {
        MapValueOperator mapValueOperator = valueClass.equals(RealmAny.class.getCanonicalName()) ? new RealmAnyValueOperator<String>(baseRealm, osMap, new SelectorForMap<String, RealmAny>(baseRealm, osMap, String.class, RealmAny.class)) : (valueClass.equals(Long.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, Long>(Long.class, baseRealm, osMap, new SelectorForMap<String, Long>(baseRealm, osMap, String.class, Long.class), RealmMapEntrySet.IteratorType.LONG) : (valueClass.equals(Float.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, Float>(Float.class, baseRealm, osMap, new SelectorForMap<String, Float>(baseRealm, osMap, String.class, Float.class), RealmMapEntrySet.IteratorType.FLOAT) : (valueClass.equals(Double.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, Double>(Double.class, baseRealm, osMap, new SelectorForMap<String, Double>(baseRealm, osMap, String.class, Double.class), RealmMapEntrySet.IteratorType.DOUBLE) : (valueClass.equals(String.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, String>(String.class, baseRealm, osMap, new SelectorForMap<String, String>(baseRealm, osMap, String.class, String.class), RealmMapEntrySet.IteratorType.STRING) : (valueClass.equals(Boolean.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, Boolean>(Boolean.class, baseRealm, osMap, new SelectorForMap<String, Boolean>(baseRealm, osMap, String.class, Boolean.class), RealmMapEntrySet.IteratorType.BOOLEAN) : (valueClass.equals(Date.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, Date>(Date.class, baseRealm, osMap, new SelectorForMap<String, Date>(baseRealm, osMap, String.class, Date.class), RealmMapEntrySet.IteratorType.DATE) : (valueClass.equals(Decimal128.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, Decimal128>(Decimal128.class, baseRealm, osMap, new SelectorForMap<String, Decimal128>(baseRealm, osMap, String.class, Decimal128.class), RealmMapEntrySet.IteratorType.DECIMAL128) : (valueClass.equals(Integer.class.getCanonicalName()) ? new IntegerValueOperator<String>(baseRealm, osMap, new SelectorForMap<String, Integer>(baseRealm, osMap, String.class, Integer.class)) : (valueClass.equals(Short.class.getCanonicalName()) ? new ShortValueOperator<String>(baseRealm, osMap, new SelectorForMap<String, Short>(baseRealm, osMap, String.class, Short.class)) : (valueClass.equals(Byte.class.getCanonicalName()) ? new ByteValueOperator<String>(baseRealm, osMap, new SelectorForMap<String, Byte>(baseRealm, osMap, String.class, Byte.class)) : (valueClass.equals(byte[].class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, byte[]>(byte[].class, baseRealm, osMap, new SelectorForMap<String, byte[]>(baseRealm, osMap, String.class, byte[].class), RealmMapEntrySet.IteratorType.BINARY, new BinaryEquals()) : (valueClass.equals(ObjectId.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, ObjectId>(ObjectId.class, baseRealm, osMap, new SelectorForMap<String, ObjectId>(baseRealm, osMap, String.class, ObjectId.class), RealmMapEntrySet.IteratorType.OBJECT_ID) : (valueClass.equals(UUID.class.getCanonicalName()) ? new GenericPrimitiveValueOperator<String, UUID>(UUID.class, baseRealm, osMap, new SelectorForMap<String, UUID>(baseRealm, osMap, String.class, UUID.class), RealmMapEntrySet.IteratorType.UUID) : new RealmModelValueOperator(baseRealm, osMap, new DynamicSelectorForMap(baseRealm, osMap, valueClass)))))))))))))));
        return new DictionaryManager(baseRealm, mapValueOperator, mapValueOperator.typeSelectorForMap);
    }
}

