/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.SetValueOperator;
import io.realm.internal.OsSet;
import io.realm.internal.core.NativeRealmAnyCollection;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;

class ObjectIdOperator
extends SetValueOperator<ObjectId> {
    ObjectIdOperator(BaseRealm baseRealm, OsSet osSet, Class<ObjectId> valueClass) {
        super(baseRealm, osSet, valueClass);
    }

    @Override
    boolean add(@Nullable ObjectId value) {
        return this.osSet.add(value);
    }

    @Override
    boolean containsInternal(@Nullable Object o) {
        ObjectId value = o == null ? null : (ObjectId)o;
        return this.osSet.contains(value);
    }

    @Override
    boolean removeInternal(@Nullable Object o) {
        return this.osSet.remove((ObjectId)o);
    }

    @Override
    boolean containsAllInternal(Collection<?> c) {
        Collection<?> objectIdCollection = c;
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newObjectIdCollection(objectIdCollection);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.CONTAINS_ALL);
    }

    @Override
    boolean addAllInternal(Collection<? extends ObjectId> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newObjectIdCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.ADD_ALL);
    }

    @Override
    boolean removeAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newObjectIdCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.REMOVE_ALL);
    }

    @Override
    boolean retainAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newObjectIdCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.RETAIN_ALL);
    }
}

