/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.RealmMapEntrySet;
import io.realm.TypeSelectorForMap;
import io.realm.internal.ObservableMap;
import io.realm.internal.OsMap;
import io.realm.internal.util.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class MapValueOperator<K, V> {
    protected final Class<V> valueClass;
    protected final BaseRealm baseRealm;
    protected final OsMap osMap;
    protected final TypeSelectorForMap<K, V> typeSelectorForMap;
    protected final RealmMapEntrySet.IteratorType iteratorType;

    MapValueOperator(Class<V> valueClass, BaseRealm baseRealm, OsMap osMap, TypeSelectorForMap<K, V> typeSelectorForMap, RealmMapEntrySet.IteratorType iteratorType) {
        this.valueClass = valueClass;
        this.baseRealm = baseRealm;
        this.osMap = osMap;
        this.typeSelectorForMap = typeSelectorForMap;
        this.iteratorType = iteratorType;
    }

    @Nullable
    abstract V get(K var1);

    @Nullable
    abstract V put(K var1, @Nullable V var2);

    abstract Set<Map.Entry<K, V>> entrySet();

    abstract boolean containsValueInternal(@Nullable Object var1);

    void remove(Object key) {
        this.osMap.remove(key);
    }

    int size() {
        return (int)this.osMap.size();
    }

    boolean isEmpty() {
        return this.osMap.size() == 0L;
    }

    boolean containsKey(Object key) {
        return this.osMap.containsKey(key);
    }

    boolean containsValue(@Nullable Object value) {
        if (value != null && value.getClass() != this.valueClass) {
            throw new ClassCastException("Only '" + this.valueClass.getSimpleName() + "'  values can be used with 'containsValue'.");
        }
        return this.containsValueInternal(value);
    }

    boolean isValid() {
        if (this.baseRealm.isClosed()) {
            return false;
        }
        return this.osMap.isValid();
    }

    boolean isFrozen() {
        return this.baseRealm.isFrozen();
    }

    void clear() {
        this.osMap.clear();
    }

    void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    Set<K> keySet() {
        return this.typeSelectorForMap.keySet();
    }

    Collection<V> values() {
        return this.typeSelectorForMap.getValues();
    }

    Pair<BaseRealm, OsMap> freeze() {
        BaseRealm frozenRealm = this.baseRealm.freeze();
        return new Pair<BaseRealm, OsMap>(frozenRealm, this.osMap.freeze(frozenRealm.sharedRealm));
    }

    void startListening(ObservableMap observableMap) {
        this.osMap.startListening(observableMap);
    }

    void stopListening() {
        this.osMap.stopListening();
    }
}

