/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.EqualsHelper;
import io.realm.GenericEquals;
import io.realm.RealmAny;
import io.realm.RealmAnyOperator;
import io.realm.TypeSelectorForMap;
import io.realm.internal.OsMap;
import io.realm.internal.core.NativeRealmAny;
import io.realm.internal.util.Pair;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;

class RealmMapEntrySet<K, V>
implements Set<Map.Entry<K, V>> {
    private final BaseRealm baseRealm;
    private final OsMap osMap;
    private final IteratorType iteratorType;
    private final EqualsHelper<K, V> equalsHelper;
    private final TypeSelectorForMap<K, V> typeSelectorForMap;

    RealmMapEntrySet(BaseRealm baseRealm, OsMap osMap, IteratorType iteratorType, @Nullable TypeSelectorForMap<K, V> typeSelectorForMap) {
        this.baseRealm = baseRealm;
        this.osMap = osMap;
        this.iteratorType = iteratorType;
        this.equalsHelper = new GenericEquals();
        this.typeSelectorForMap = typeSelectorForMap;
    }

    RealmMapEntrySet(BaseRealm baseRealm, OsMap osMap, IteratorType iteratorType, EqualsHelper<K, V> equalsHelper, @Nullable TypeSelectorForMap<K, V> typeSelectorForMap) {
        this.baseRealm = baseRealm;
        this.osMap = osMap;
        this.iteratorType = iteratorType;
        this.equalsHelper = equalsHelper;
        this.typeSelectorForMap = typeSelectorForMap;
    }

    @Override
    public int size() {
        long actualMap = this.osMap.size();
        return actualMap < Integer.MAX_VALUE ? (int)actualMap : Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.osMap.size() == 0L;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        for (Map.Entry<K, V> entry : this) {
            if (entry == null && o == null) {
                return true;
            }
            if (o instanceof Map.Entry) {
                if (entry == null || !this.equalsHelper.equalsHelper(entry, (Map.Entry)o)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return RealmMapEntrySet.iteratorFactory(this.iteratorType, this.osMap, this.baseRealm, this.typeSelectorForMap);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[(int)this.osMap.size()];
        int i = 0;
        Iterator<Map.Entry<K, V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry;
            array[i] = entry = iterator.next();
            ++i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        long mapSize = this.osMap.size();
        Object[] array = (long)a.length == mapSize || (long)a.length > mapSize ? a : (Object[])Array.newInstance(Map.Entry.class, (int)mapSize);
        int i = 0;
        for (Map.Entry<K, V> entry : this) {
            array[i] = entry;
            ++i;
        }
        if ((long)a.length > mapSize) {
            array[i] = null;
        }
        return array;
    }

    @Override
    public boolean add(Map.Entry<K, V> entry) {
        throw new UnsupportedOperationException("This set is immutable and cannot be modified.");
    }

    @Override
    public boolean remove(@Nullable Object o) {
        throw new UnsupportedOperationException("This set is immutable and cannot be modified.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return this.isEmpty();
        }
        for (Object elem : c) {
            if (elem instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)elem;
                if (this.contains(entry)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
        throw new UnsupportedOperationException("This set is immutable and cannot be modified.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This set is immutable and cannot be modified.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This set is immutable and cannot be modified.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This set is immutable and cannot be modified.");
    }

    private static <K, V> EntrySetIterator<K, V> iteratorFactory(IteratorType iteratorType, OsMap osMap, BaseRealm baseRealm, @Nullable TypeSelectorForMap typeSelectorForMap) {
        switch (iteratorType) {
            case LONG: {
                return new LongValueIterator(osMap, baseRealm);
            }
            case BYTE: {
                return new ByteValueIterator(osMap, baseRealm);
            }
            case SHORT: {
                return new ShortValueIterator(osMap, baseRealm);
            }
            case INTEGER: {
                return new IntegerValueIterator(osMap, baseRealm);
            }
            case FLOAT: {
                return new FloatValueIterator(osMap, baseRealm);
            }
            case DOUBLE: {
                return new DoubleValueIterator(osMap, baseRealm);
            }
            case STRING: {
                return new StringValueIterator(osMap, baseRealm);
            }
            case BOOLEAN: {
                return new BooleanValueIterator(osMap, baseRealm);
            }
            case DATE: {
                return new DateValueIterator(osMap, baseRealm);
            }
            case DECIMAL128: {
                return new Decimal128ValueIterator(osMap, baseRealm);
            }
            case BINARY: {
                return new BinaryValueIterator(osMap, baseRealm);
            }
            case OBJECT_ID: {
                return new ObjectIdValueIterator(osMap, baseRealm);
            }
            case UUID: {
                return new UUIDValueIterator(osMap, baseRealm);
            }
            case MIXED: {
                return new RealmAnyValueIterator(osMap, baseRealm);
            }
            case OBJECT: {
                if (typeSelectorForMap == null) {
                    throw new IllegalArgumentException("Missing class container when creating RealmModelValueIterator.");
                }
                return new RealmModelValueIterator(osMap, baseRealm, typeSelectorForMap);
            }
        }
        throw new IllegalArgumentException("Invalid iterator type.");
    }

    private static class RealmAnyValueIterator<K>
    extends EntrySetIterator<K, RealmAny> {
        RealmAnyValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, RealmAny> getEntryInternal(int position) {
            Pair pair = this.osMap.getKeyRealmAnyPair(position);
            Object key = pair.first;
            NativeRealmAny nativeRealmAny = (NativeRealmAny)pair.second;
            RealmAny value = new RealmAny(RealmAnyOperator.fromNativeRealmAny(this.baseRealm, nativeRealmAny));
            return new AbstractMap.SimpleImmutableEntry(key, value);
        }
    }

    private static class RealmModelValueIterator<K, V>
    extends EntrySetIterator<K, V> {
        private final TypeSelectorForMap<K, V> typeSelectorForMap;

        RealmModelValueIterator(OsMap osMap, BaseRealm baseRealm, TypeSelectorForMap<K, V> typeSelectorForMap) {
            super(osMap, baseRealm);
            this.typeSelectorForMap = typeSelectorForMap;
        }

        @Override
        protected Map.Entry<K, V> getEntryInternal(int position) {
            Pair pair = this.osMap.getKeyObjRowPair(position);
            Object key = pair.first;
            long objRow = (Long)pair.second;
            if (objRow == -1L) {
                return new AbstractMap.SimpleImmutableEntry(key, null);
            }
            return this.typeSelectorForMap.getModelEntry(this.baseRealm, objRow, key);
        }
    }

    private static class UUIDValueIterator<K>
    extends EntrySetIterator<K, UUID> {
        UUIDValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, UUID> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (UUID)pair.second);
        }
    }

    private static class ObjectIdValueIterator<K>
    extends EntrySetIterator<K, ObjectId> {
        ObjectIdValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, ObjectId> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (ObjectId)pair.second);
        }
    }

    private static class BinaryValueIterator<K>
    extends EntrySetIterator<K, byte[]> {
        BinaryValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, byte[]> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (byte[])pair.second);
        }
    }

    private static class Decimal128ValueIterator<K>
    extends EntrySetIterator<K, Decimal128> {
        Decimal128ValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Decimal128> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (Decimal128)pair.second);
        }
    }

    private static class DateValueIterator<K>
    extends EntrySetIterator<K, Date> {
        DateValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Date> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (Date)pair.second);
        }
    }

    private static class BooleanValueIterator<K>
    extends EntrySetIterator<K, Boolean> {
        BooleanValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Boolean> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (Boolean)pair.second);
        }
    }

    private static class StringValueIterator<K>
    extends EntrySetIterator<K, String> {
        StringValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, String> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (String)pair.second);
        }
    }

    private static class DoubleValueIterator<K>
    extends EntrySetIterator<K, Double> {
        DoubleValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Double> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (Double)pair.second);
        }
    }

    private static class FloatValueIterator<K>
    extends EntrySetIterator<K, Float> {
        FloatValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Float> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            return new AbstractMap.SimpleImmutableEntry(pair.first, (Float)pair.second);
        }
    }

    private static class IntegerValueIterator<K>
    extends EntrySetIterator<K, Integer> {
        IntegerValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Integer> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            Long longValue = (Long)pair.second;
            return new AbstractMap.SimpleImmutableEntry(pair.first, longValue.intValue());
        }
    }

    private static class ShortValueIterator<K>
    extends EntrySetIterator<K, Short> {
        ShortValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Short> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            Long longValue = (Long)pair.second;
            return new AbstractMap.SimpleImmutableEntry(pair.first, longValue.shortValue());
        }
    }

    private static class ByteValueIterator<K>
    extends EntrySetIterator<K, Byte> {
        ByteValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Byte> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            Long longValue = (Long)pair.second;
            return new AbstractMap.SimpleImmutableEntry(pair.first, longValue.byteValue());
        }
    }

    private static class LongValueIterator<K>
    extends EntrySetIterator<K, Long> {
        LongValueIterator(OsMap osMap, BaseRealm baseRealm) {
            super(osMap, baseRealm);
        }

        @Override
        protected Map.Entry<K, Long> getEntryInternal(int position) {
            Pair pair = this.osMap.getEntryForPrimitive(position);
            if (pair.second == null) {
                return new AbstractMap.SimpleImmutableEntry(pair.first, null);
            }
            Long longValue = (Long)pair.second;
            return new AbstractMap.SimpleImmutableEntry(pair.first, longValue);
        }
    }

    private static abstract class EntrySetIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        protected final OsMap osMap;
        protected final BaseRealm baseRealm;
        private int pos = -1;

        EntrySetIterator(OsMap osMap, BaseRealm baseRealm) {
            this.osMap = osMap;
            this.baseRealm = baseRealm;
        }

        protected abstract Map.Entry<K, V> getEntryInternal(int var1);

        @Override
        public boolean hasNext() {
            return (long)(this.pos + 1) < this.osMap.size();
        }

        @Override
        public Map.Entry<K, V> next() {
            ++this.pos;
            long size = this.osMap.size();
            if ((long)this.pos >= size) {
                throw new NoSuchElementException("Cannot access index " + this.pos + " when size is " + size + ". Remember to check hasNext() before using next().");
            }
            return this.getEntryInternal(this.pos);
        }
    }

    public static enum IteratorType {
        LONG,
        BYTE,
        SHORT,
        INTEGER,
        FLOAT,
        DOUBLE,
        STRING,
        BOOLEAN,
        DATE,
        DECIMAL128,
        BINARY,
        OBJECT_ID,
        UUID,
        MIXED,
        OBJECT;

    }
}

