/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.RealmAny;
import io.realm.RealmModel;
import io.realm.SetValueOperator;
import io.realm.internal.OsSet;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.core.NativeRealmAnyCollection;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

class RealmAnySetOperator
extends SetValueOperator<RealmAny> {
    RealmAnySetOperator(BaseRealm baseRealm, OsSet osSet, Class<RealmAny> valueClass) {
        super(baseRealm, osSet, valueClass);
    }

    @Override
    boolean add(@Nullable RealmAny value) {
        value = this.getManagedRealmAny(value);
        return this.osSet.addRealmAny(value.getNativePtr());
    }

    @NotNull
    private RealmAny getManagedRealmAny(@Nullable RealmAny value) {
        if (value == null) {
            value = RealmAny.nullValue();
        } else if (value.getType() == RealmAny.Type.OBJECT) {
            RealmModel realmModel = value.asRealmModel(RealmModel.class);
            boolean copyObject = CollectionUtils.checkCanObjectBeCopied(this.baseRealm, realmModel, this.valueClass.getName(), "set");
            RealmObjectProxy proxy = (RealmObjectProxy)(copyObject ? CollectionUtils.copyToRealm(this.baseRealm, realmModel) : realmModel);
            value = RealmAny.valueOf(proxy);
        }
        return value;
    }

    @Override
    boolean containsInternal(@Nullable Object o) {
        RealmAny value = o == null ? RealmAny.nullValue() : (RealmAny)o;
        this.checkValidObject(value);
        return this.osSet.containsRealmAny(value.getNativePtr());
    }

    @Override
    boolean removeInternal(@Nullable Object o) {
        RealmAny value = o == null ? RealmAny.nullValue() : (RealmAny)o;
        this.checkValidObject(value);
        return this.osSet.removeRealmAny(value.getNativePtr());
    }

    @NotNull
    private NativeRealmAnyCollection getNativeRealmAnyCollection(Collection<? extends RealmAny> realmAnyCollection) {
        long[] realmAnyPtrs = new long[realmAnyCollection.size()];
        boolean[] notNull = new boolean[realmAnyCollection.size()];
        int i = 0;
        for (RealmAny realmAny : realmAnyCollection) {
            if (realmAny != null) {
                this.checkValidObject(realmAny);
                realmAnyPtrs[i] = realmAny.getNativePtr();
                notNull[i] = true;
            }
            ++i;
        }
        return NativeRealmAnyCollection.newRealmAnyCollection(realmAnyPtrs, notNull);
    }

    @Override
    boolean containsAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = this.getNativeRealmAnyCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.CONTAINS_ALL);
    }

    @Override
    boolean addAllInternal(Collection<? extends RealmAny> collection) {
        ArrayList<RealmAny> managedRealmAnyCollection = new ArrayList<RealmAny>(collection.size());
        for (RealmAny realmAny : collection) {
            managedRealmAnyCollection.add(this.getManagedRealmAny(realmAny));
        }
        NativeRealmAnyCollection nativeRealmAnyCollection = this.getNativeRealmAnyCollection(managedRealmAnyCollection);
        return this.osSet.collectionFunnel(nativeRealmAnyCollection, OsSet.ExternalCollectionOperation.ADD_ALL);
    }

    @Override
    boolean removeAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = this.getNativeRealmAnyCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.REMOVE_ALL);
    }

    @Override
    boolean retainAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = this.getNativeRealmAnyCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.RETAIN_ALL);
    }

    private void checkValidObject(RealmAny realmAny) {
        try {
            realmAny.checkValidObject(this.baseRealm);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("RealmAny collection contains unmanaged objects.", exception);
        }
    }
}

