/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleTimeout<T>
extends Single<T> {
    final SingleSource<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final SingleSource<? extends T> other;

    public SingleTimeout(SingleSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler, SingleSource<? extends T> other) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        TimeoutMainObserver<? extends T> parent = new TimeoutMainObserver<T>(s, this.other);
        s.onSubscribe(parent);
        DisposableHelper.replace(parent.task, this.scheduler.scheduleDirect(parent, this.timeout, this.unit));
        this.source.subscribe(parent);
    }

    static final class TimeoutMainObserver<T>
    extends AtomicReference<Disposable>
    implements SingleObserver<T>,
    Runnable,
    Disposable {
        private static final long serialVersionUID = 37497744973048446L;
        final SingleObserver<? super T> actual;
        final AtomicReference<Disposable> task;
        final TimeoutFallbackObserver<T> fallback;
        SingleSource<? extends T> other;

        TimeoutMainObserver(SingleObserver<? super T> actual, SingleSource<? extends T> other) {
            this.actual = actual;
            this.other = other;
            this.task = new AtomicReference();
            this.fallback = other != null ? new TimeoutFallbackObserver<T>(actual) : null;
        }

        @Override
        public void run() {
            Disposable d = (Disposable)this.get();
            if (d != DisposableHelper.DISPOSED && this.compareAndSet(d, DisposableHelper.DISPOSED)) {
                SingleSource<T> other;
                if (d != null) {
                    d.dispose();
                }
                if ((other = this.other) == null) {
                    this.actual.onError(new TimeoutException());
                } else {
                    this.other = null;
                    other.subscribe(this.fallback);
                }
            }
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onSuccess(T t) {
            Disposable d = (Disposable)this.get();
            if (d != DisposableHelper.DISPOSED && this.compareAndSet(d, DisposableHelper.DISPOSED)) {
                DisposableHelper.dispose(this.task);
                this.actual.onSuccess(t);
            }
        }

        @Override
        public void onError(Throwable e) {
            Disposable d = (Disposable)this.get();
            if (d != DisposableHelper.DISPOSED && this.compareAndSet(d, DisposableHelper.DISPOSED)) {
                DisposableHelper.dispose(this.task);
                this.actual.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            DisposableHelper.dispose(this.task);
            if (this.fallback != null) {
                DisposableHelper.dispose(this.fallback);
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        static final class TimeoutFallbackObserver<T>
        extends AtomicReference<Disposable>
        implements SingleObserver<T> {
            private static final long serialVersionUID = 2071387740092105509L;
            final SingleObserver<? super T> actual;

            TimeoutFallbackObserver(SingleObserver<? super T> actual) {
                this.actual = actual;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(T t) {
                this.actual.onSuccess(t);
            }

            @Override
            public void onError(Throwable e) {
                this.actual.onError(e);
            }
        }
    }
}

