/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.parallel.ParallelFlowable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelFromPublisher<T>
extends ParallelFlowable<T> {
    final Publisher<? extends T> source;
    final int parallelism;
    final int prefetch;

    public ParallelFromPublisher(Publisher<? extends T> source, int parallelism, int prefetch) {
        this.source = source;
        this.parallelism = parallelism;
        this.prefetch = prefetch;
    }

    @Override
    public int parallelism() {
        return this.parallelism;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        this.source.subscribe(new ParallelDispatcher<T>(subscribers, this.prefetch));
    }

    static final class ParallelDispatcher<T>
    extends AtomicInteger
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -4470634016609963609L;
        final Subscriber<? super T>[] subscribers;
        final AtomicLongArray requests;
        final long[] emissions;
        final int prefetch;
        final int limit;
        Subscription s;
        SimpleQueue<T> queue;
        Throwable error;
        volatile boolean done;
        int index;
        volatile boolean cancelled;
        final AtomicInteger subscriberCount = new AtomicInteger();
        int produced;
        int sourceMode;

        ParallelDispatcher(Subscriber<? super T>[] subscribers, int prefetch) {
            this.subscribers = subscribers;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            int m = subscribers.length;
            this.requests = new AtomicLongArray(m + m + 1);
            this.requests.lazySet(m + m, m);
            this.emissions = new long[m];
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.setupSubscribers();
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.setupSubscribers();
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.setupSubscribers();
                s.request((long)this.prefetch);
            }
        }

        void setupSubscribers() {
            Subscriber<? super T>[] subs = this.subscribers;
            int m = subs.length;
            for (int i = 0; i < m; ++i) {
                if (this.cancelled) {
                    return;
                }
                this.subscriberCount.lazySet(i + 1);
                subs[i].onSubscribe((Subscription)new RailSubscription(i, m));
            }
        }

        public void onNext(T t) {
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.s.cancel();
                this.onError(new MissingBackpressureException("Queue is full?"));
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void cancel(int m) {
            if (this.requests.decrementAndGet(m) == 0L) {
                this.cancelled = true;
                this.s.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drainAsync() {
            int missed = 1;
            SimpleQueue<T> q = this.queue;
            Subscriber<? super T>[] a = this.subscribers;
            AtomicLongArray r = this.requests;
            long[] e = this.emissions;
            int n = e.length;
            int idx = this.index;
            int consumed = this.produced;
            while (true) {
                int w;
                int notReady = 0;
                do {
                    long eidx;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        for (Subscriber<? super T> s : a) {
                            s.onError(ex);
                        }
                        return;
                    }
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        for (Subscriber<? super T> s : a) {
                            s.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    long ridx = r.get(idx);
                    if (ridx != (eidx = e[idx]) && r.get(n + idx) == 0L) {
                        T v;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex2) {
                            Exceptions.throwIfFatal(ex2);
                            this.s.cancel();
                            for (Subscriber<? super T> s : a) {
                                s.onError(ex2);
                            }
                            return;
                        }
                        if (v == null) break;
                        a[idx].onNext(v);
                        e[idx] = eidx + 1L;
                        int c = ++consumed;
                        if (c == this.limit) {
                            consumed = 0;
                            this.s.request((long)c);
                        }
                        notReady = 0;
                    } else {
                        ++notReady;
                    }
                    if (++idx != n) continue;
                    idx = 0;
                } while (notReady != n);
                if ((w = this.get()) == missed) {
                    this.index = idx;
                    this.produced = consumed;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void drainSync() {
            int missed = 1;
            SimpleQueue<T> q = this.queue;
            Subscriber<? super T>[] a = this.subscribers;
            AtomicLongArray r = this.requests;
            long[] e = this.emissions;
            int n = e.length;
            int idx = this.index;
            while (true) {
                int notReady = 0;
                do {
                    long eidx;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean empty = q.isEmpty();
                    if (empty) {
                        for (Subscriber<? super T> s : a) {
                            s.onComplete();
                        }
                        return;
                    }
                    long ridx = r.get(idx);
                    if (ridx != (eidx = e[idx]) && r.get(n + idx) == 0L) {
                        T v;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.s.cancel();
                            for (Subscriber<? super T> s : a) {
                                s.onError(ex);
                            }
                            return;
                        }
                        if (v == null) {
                            for (Subscriber<? super T> s : a) {
                                s.onComplete();
                            }
                            return;
                        }
                        a[idx].onNext(v);
                        e[idx] = eidx + 1L;
                        notReady = 0;
                    } else {
                        ++notReady;
                    }
                    if (++idx != n) continue;
                    idx = 0;
                } while (notReady != n);
                int w = this.get();
                if (w == missed) {
                    this.index = idx;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.sourceMode == 1) {
                this.drainSync();
            } else {
                this.drainAsync();
            }
        }

        final class RailSubscription
        implements Subscription {
            final int j;
            final int m;

            RailSubscription(int j, int m) {
                this.j = j;
                this.m = m;
            }

            public void request(long n) {
                if (SubscriptionHelper.validate(n)) {
                    long u;
                    long r;
                    AtomicLongArray ra = ParallelDispatcher.this.requests;
                    do {
                        if ((r = ra.get(this.j)) != Long.MAX_VALUE) continue;
                        return;
                    } while (!ra.compareAndSet(this.j, r, u = BackpressureHelper.addCap(r, n)));
                    if (ParallelDispatcher.this.subscriberCount.get() == this.m) {
                        ParallelDispatcher.this.drain();
                    }
                }
            }

            public void cancel() {
                if (ParallelDispatcher.this.requests.compareAndSet(this.m + this.j, 0L, 1L)) {
                    ParallelDispatcher.this.cancel(this.m + this.m);
                }
            }
        }
    }
}

