/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import java.util.concurrent.Callable;

public final class CompletableToSingle<T>
extends Single<T> {
    final CompletableSource source;
    final Callable<? extends T> completionValueSupplier;
    final T completionValue;

    public CompletableToSingle(CompletableSource source, Callable<? extends T> completionValueSupplier, T completionValue) {
        this.source = source;
        this.completionValue = completionValue;
        this.completionValueSupplier = completionValueSupplier;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        this.source.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                Object v;
                if (CompletableToSingle.this.completionValueSupplier != null) {
                    try {
                        v = CompletableToSingle.this.completionValueSupplier.call();
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        s.onError(e);
                        return;
                    }
                } else {
                    v = CompletableToSingle.this.completionValue;
                }
                if (v == null) {
                    s.onError(new NullPointerException("The value supplied is null"));
                } else {
                    s.onSuccess(v);
                }
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
            }

            @Override
            public void onSubscribe(Disposable d) {
                s.onSubscribe(d);
            }
        });
    }
}

