/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.schedulers.RxThreadFactory;
import io.reactivex.internal.schedulers.ScheduledRunnable;
import io.reactivex.internal.schedulers.SchedulerPoolFactory;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleScheduler
extends Scheduler {
    final ThreadFactory threadFactory;
    final AtomicReference<ScheduledExecutorService> executor = new AtomicReference();
    private static final String KEY_SINGLE_PRIORITY = "rx2.single-priority";
    private static final String THREAD_NAME_PREFIX = "RxSingleScheduler";
    static final RxThreadFactory SINGLE_THREAD_FACTORY;
    static final ScheduledExecutorService SHUTDOWN;

    public SingleScheduler() {
        this(SINGLE_THREAD_FACTORY);
    }

    public SingleScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.executor.lazySet(SingleScheduler.createExecutor(threadFactory));
    }

    static ScheduledExecutorService createExecutor(ThreadFactory threadFactory) {
        return SchedulerPoolFactory.create(threadFactory);
    }

    @Override
    public void start() {
        ScheduledExecutorService current;
        ExecutorService next = null;
        do {
            if ((current = this.executor.get()) != SHUTDOWN) {
                if (next != null) {
                    next.shutdown();
                }
                return;
            }
            if (next != null) continue;
            next = SingleScheduler.createExecutor(this.threadFactory);
        } while (!this.executor.compareAndSet(current, (ScheduledExecutorService)next));
    }

    @Override
    public void shutdown() {
        ScheduledExecutorService current = this.executor.get();
        if (current != SHUTDOWN && (current = this.executor.getAndSet(SHUTDOWN)) != SHUTDOWN) {
            current.shutdownNow();
        }
    }

    @Override
    @NonNull
    public Scheduler.Worker createWorker() {
        return new ScheduledWorker(this.executor.get());
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        try {
            Future<?> f = delay <= 0L ? this.executor.get().submit(decoratedRun) : this.executor.get().schedule(decoratedRun, delay, unit);
            return Disposables.fromFuture(f);
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @Override
    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        try {
            ScheduledFuture<?> f = this.executor.get().scheduleAtFixedRate(decoratedRun, initialDelay, period, unit);
            return Disposables.fromFuture(f);
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    static {
        SHUTDOWN = Executors.newScheduledThreadPool(0);
        SHUTDOWN.shutdown();
        int priority = Math.max(1, Math.min(10, Integer.getInteger(KEY_SINGLE_PRIORITY, 5)));
        SINGLE_THREAD_FACTORY = new RxThreadFactory(THREAD_NAME_PREFIX, priority, true);
    }

    static final class ScheduledWorker
    extends Scheduler.Worker {
        final ScheduledExecutorService executor;
        final CompositeDisposable tasks;
        volatile boolean disposed;

        ScheduledWorker(ScheduledExecutorService executor) {
            this.executor = executor;
            this.tasks = new CompositeDisposable();
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            ScheduledRunnable sr = new ScheduledRunnable(decoratedRun, this.tasks);
            this.tasks.add(sr);
            try {
                Future<Object> f = delay <= 0L ? this.executor.submit(sr) : this.executor.schedule(sr, delay, unit);
                sr.setFuture(f);
            }
            catch (RejectedExecutionException ex) {
                this.dispose();
                RxJavaPlugins.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
            return sr;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.tasks.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

