/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscribers.InnerQueuedSubscriber;
import io.reactivex.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapEager<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int maxConcurrency;
    final int prefetch;
    final ErrorMode errorMode;

    public FlowableConcatMapEager(Publisher<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
        super(source);
        this.mapper = mapper;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new ConcatMapEagerDelayErrorSubscriber<T, R>(s, this.mapper, this.maxConcurrency, this.prefetch, this.errorMode));
    }

    static final class ConcatMapEagerDelayErrorSubscriber<T, R>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription,
    InnerQueuedSubscriberSupport<R> {
        private static final long serialVersionUID = -4255299542215038287L;
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int maxConcurrency;
        final int prefetch;
        final ErrorMode errorMode;
        final AtomicReference<Throwable> error;
        final AtomicLong requested;
        final SpscLinkedArrayQueue<InnerQueuedSubscriber<R>> subscribers;
        Subscription s;
        volatile boolean cancelled;
        volatile boolean done;
        volatile InnerQueuedSubscriber<R> current;

        ConcatMapEagerDelayErrorSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
            this.actual = actual;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.subscribers = new SpscLinkedArrayQueue(Math.min(prefetch, maxConcurrency));
            this.error = new AtomicReference();
            this.requested = new AtomicLong();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(this.maxConcurrency == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.maxConcurrency);
            }
        }

        public void onNext(T t) {
            Publisher<? extends R> p;
            try {
                p = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.s.cancel();
                this.onError(ex);
                return;
            }
            InnerQueuedSubscriber inner = new InnerQueuedSubscriber(this, this.prefetch);
            if (this.cancelled) {
                return;
            }
            this.subscribers.offer(inner);
            if (this.cancelled) {
                return;
            }
            p.subscribe(inner);
            if (this.cancelled) {
                inner.cancel();
                this.drainAndCancel();
            }
        }

        public void onError(Throwable t) {
            if (ExceptionHelper.addThrowable(this.error, t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.s.cancel();
            this.drainAndCancel();
        }

        void drainAndCancel() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.cancelAll();
                } while (this.decrementAndGet() != 0);
            }
        }

        void cancelAll() {
            InnerQueuedSubscriber<R> inner;
            while ((inner = this.subscribers.poll()) != null) {
                inner.cancel();
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void innerNext(InnerQueuedSubscriber<R> inner, R value) {
            if (inner.queue().offer(value)) {
                this.drain();
            } else {
                inner.cancel();
                this.innerError(inner, (Throwable)new MissingBackpressureException());
            }
        }

        @Override
        public void innerError(InnerQueuedSubscriber<R> inner, Throwable e) {
            if (ExceptionHelper.addThrowable(this.error, e)) {
                inner.setDone();
                if (this.errorMode != ErrorMode.END) {
                    this.s.cancel();
                }
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void innerComplete(InnerQueuedSubscriber<R> inner) {
            inner.setDone();
            this.drain();
        }

        @Override
        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            InnerQueuedSubscriber<R> inner = this.current;
            Subscriber<? super R> a = this.actual;
            long r = this.requested.get();
            long e = 0L;
            ErrorMode em = this.errorMode;
            block2: while (true) {
                SimpleQueue<R> q;
                if (inner == null) {
                    Throwable ex;
                    if (em != ErrorMode.END && (ex = this.error.get()) != null) {
                        this.cancelAll();
                        a.onError(ex);
                        return;
                    }
                    boolean outerDone = this.done;
                    inner = this.subscribers.poll();
                    if (outerDone && inner == null) {
                        Throwable ex2 = this.error.get();
                        if (ex2 != null) {
                            a.onError(ex2);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (inner != null) {
                        this.current = inner;
                    }
                }
                if (inner != null && (q = inner.queue()) != null) {
                    boolean d;
                    while (e != r) {
                        boolean empty;
                        R v;
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == ErrorMode.IMMEDIATE && (ex = this.error.get()) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a.onError(ex);
                            return;
                        }
                        d = inner.isDone();
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex3) {
                            Exceptions.throwIfFatal(ex3);
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a.onError(ex3);
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            inner = null;
                            this.current = null;
                            this.s.request(1L);
                            continue block2;
                        }
                        if (empty) break;
                        a.onNext(v);
                        ++e;
                        inner.requestOne();
                    }
                    if (e == r) {
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == ErrorMode.IMMEDIATE && (ex = this.error.get()) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a.onError(ex);
                            return;
                        }
                        d = inner.isDone();
                        boolean empty = q.isEmpty();
                        if (d && empty) {
                            inner = null;
                            this.current = null;
                            this.s.request(1L);
                            continue;
                        }
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    r = this.requested.addAndGet(-e);
                    e = 0L;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

