/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleAmb<T>
extends Single<T> {
    private final SingleSource<? extends T>[] sources;
    private final Iterable<? extends SingleSource<? extends T>> sourcesIterable;

    public SingleAmb(SingleSource<? extends T>[] sources, Iterable<? extends SingleSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        SingleSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new SingleSource[8];
            try {
                for (SingleSource<? extends T> singleSource : this.sourcesIterable) {
                    if (singleSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), s);
                        return;
                    }
                    if (count == sources.length) {
                        SingleSource[] b = new SingleSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b, 0, count);
                        sources = b;
                    }
                    sources[count++] = singleSource;
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptyDisposable.error(e, s);
                return;
            }
        } else {
            count = sources.length;
        }
        final AtomicBoolean once = new AtomicBoolean();
        final CompositeDisposable compositeDisposable = new CompositeDisposable();
        s.onSubscribe(compositeDisposable);
        for (int i = 0; i < count; ++i) {
            SingleSource<T> s1 = sources[i];
            if (once.get()) {
                return;
            }
            if (s1 == null) {
                compositeDisposable.dispose();
                NullPointerException e = new NullPointerException("One of the sources is null");
                if (once.compareAndSet(false, true)) {
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
                return;
            }
            s1.subscribe(new SingleObserver<T>(){

                @Override
                public void onSubscribe(Disposable d) {
                    compositeDisposable.add(d);
                }

                @Override
                public void onSuccess(T value) {
                    if (once.compareAndSet(false, true)) {
                        compositeDisposable.dispose();
                        s.onSuccess(value);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    if (once.compareAndSet(false, true)) {
                        compositeDisposable.dispose();
                        s.onError(e);
                    } else {
                        RxJavaPlugins.onError(e);
                    }
                }
            });
        }
    }
}

