/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.observables.GroupedObservable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableGroupBy<T, K, V>
extends AbstractObservableWithUpstream<T, GroupedObservable<K, V>> {
    final Function<? super T, ? extends K> keySelector;
    final Function<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;

    public ObservableGroupBy(ObservableSource<T> source, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError) {
        super(source);
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super GroupedObservable<K, V>> t) {
        this.source.subscribe(new GroupByObserver<T, K, V>(t, this.keySelector, this.valueSelector, this.bufferSize, this.delayError));
    }

    static final class State<T, K>
    extends AtomicInteger
    implements Disposable,
    ObservableSource<T> {
        private static final long serialVersionUID = -3852313036005250360L;
        final K key;
        final SpscLinkedArrayQueue<T> queue;
        final GroupByObserver<?, K, T> parent;
        final boolean delayError;
        volatile boolean done;
        Throwable error;
        final AtomicBoolean cancelled = new AtomicBoolean();
        final AtomicReference<Observer<? super T>> actual = new AtomicReference();

        State(int bufferSize, GroupByObserver<?, K, T> parent, K key, boolean delayError) {
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.parent = parent;
            this.key = key;
            this.delayError = delayError;
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true) && this.getAndIncrement() == 0) {
                this.parent.cancel(this.key);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        @Override
        public void subscribe(Observer<? super T> s) {
            if (this.actual.compareAndSet(null, s)) {
                s.onSubscribe(this);
                this.drain();
            } else {
                EmptyDisposable.error((Throwable)new IllegalStateException("Only one Observer allowed!"), s);
            }
        }

        public void onNext(T t) {
            if (t == null) {
                this.error = new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
                this.done = true;
            } else {
                this.queue.offer(t);
            }
            this.drain();
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<T> q = this.queue;
            boolean delayError = this.delayError;
            Observer<T> a = this.actual.get();
            while (true) {
                if (a != null) {
                    if (this.checkTerminated(this.done, q.isEmpty(), a, delayError)) {
                        return;
                    }
                    while (true) {
                        boolean empty;
                        boolean d = this.done;
                        T v = q.poll();
                        boolean bl = empty = v == null;
                        if (this.checkTerminated(d, empty, a, delayError)) {
                            return;
                        }
                        if (empty) break;
                        a.onNext(v);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (a != null) continue;
                a = this.actual.get();
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Observer<? super T> a, boolean delayError) {
            if (this.cancelled.get()) {
                this.queue.clear();
                this.parent.cancel(this.key);
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }

    static final class GroupedUnicast<K, T>
    extends GroupedObservable<K, T> {
        final State<T, K> state;

        public static <T, K> GroupedUnicast<K, T> createWith(K key, int bufferSize, GroupByObserver<?, K, T> parent, boolean delayError) {
            State<T, K> state = new State<T, K>(bufferSize, parent, key, delayError);
            return new GroupedUnicast<K, T>(key, state);
        }

        protected GroupedUnicast(K key, State<T, K> state) {
            super(key);
            this.state = state;
        }

        @Override
        protected void subscribeActual(Observer<? super T> observer) {
            this.state.subscribe(observer);
        }

        public void onNext(T t) {
            this.state.onNext(t);
        }

        public void onError(Throwable e) {
            this.state.onError(e);
        }

        public void onComplete() {
            this.state.onComplete();
        }
    }

    public static final class GroupByObserver<T, K, V>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -3688291656102519502L;
        final Observer<? super GroupedObservable<K, V>> actual;
        final Function<? super T, ? extends K> keySelector;
        final Function<? super T, ? extends V> valueSelector;
        final int bufferSize;
        final boolean delayError;
        final Map<Object, GroupedUnicast<K, V>> groups;
        static final Object NULL_KEY = new Object();
        Disposable s;
        final AtomicBoolean cancelled = new AtomicBoolean();

        public GroupByObserver(Observer<? super GroupedObservable<K, V>> actual, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError) {
            this.actual = actual;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.bufferSize = bufferSize;
            this.delayError = delayError;
            this.groups = new ConcurrentHashMap<Object, GroupedUnicast<K, V>>();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            V v;
            K key;
            try {
                key = this.keySelector.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.onError(e);
                return;
            }
            Object mapKey = key != null ? key : NULL_KEY;
            GroupedUnicast<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (this.cancelled.get()) {
                    return;
                }
                group = GroupedUnicast.createWith(key, this.bufferSize, this, this.delayError);
                this.groups.put(mapKey, group);
                this.getAndIncrement();
                this.actual.onNext(group);
            }
            try {
                v = this.valueSelector.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.onError(e);
                return;
            }
            if (v == null) {
                this.s.dispose();
                this.onError(new NullPointerException("The value supplied is null"));
                return;
            }
            group.onNext(v);
        }

        @Override
        public void onError(Throwable t) {
            ArrayList<GroupedUnicast<K, V>> list = new ArrayList<GroupedUnicast<K, V>>(this.groups.values());
            this.groups.clear();
            for (GroupedUnicast groupedUnicast : list) {
                groupedUnicast.onError(t);
            }
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            ArrayList<GroupedUnicast<K, V>> list = new ArrayList<GroupedUnicast<K, V>>(this.groups.values());
            this.groups.clear();
            for (GroupedUnicast groupedUnicast : list) {
                groupedUnicast.onComplete();
            }
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true) && this.decrementAndGet() == 0) {
                this.s.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        public void cancel(K key) {
            Object mapKey = key != null ? key : NULL_KEY;
            this.groups.remove(mapKey);
            if (this.decrementAndGet() == 0) {
                this.s.dispose();
            }
        }
    }
}

