/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.ArrayCompositeDisposable;

public final class CompletableObserveOn
extends Completable {
    final CompletableSource source;
    final Scheduler scheduler;

    public CompletableObserveOn(CompletableSource source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(final CompletableObserver s) {
        final ArrayCompositeDisposable ad = new ArrayCompositeDisposable(2);
        final Scheduler.Worker w = this.scheduler.createWorker();
        ad.set(0, w);
        s.onSubscribe(ad);
        this.source.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                w.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            s.onComplete();
                        }
                        finally {
                            ad.dispose();
                        }
                    }
                });
            }

            @Override
            public void onError(final Throwable e) {
                w.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            s.onError(e);
                        }
                        finally {
                            ad.dispose();
                        }
                    }
                });
            }

            @Override
            public void onSubscribe(Disposable d) {
                ad.set(1, d);
            }
        });
    }
}

