/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class CompletableMerge
extends Completable {
    final Publisher<? extends CompletableSource> source;
    final int maxConcurrency;
    final boolean delayErrors;

    public CompletableMerge(Publisher<? extends CompletableSource> source, int maxConcurrency, boolean delayErrors) {
        this.source = source;
        this.maxConcurrency = maxConcurrency;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        CompletableMergeSubscriber parent = new CompletableMergeSubscriber(s, this.maxConcurrency, this.delayErrors);
        this.source.subscribe((Subscriber)parent);
    }

    static final class CompletableMergeSubscriber
    extends AtomicInteger
    implements Subscriber<CompletableSource>,
    Disposable {
        private static final long serialVersionUID = -2108443387387077490L;
        final CompletableObserver actual;
        final int maxConcurrency;
        final boolean delayErrors;
        final AtomicThrowable error;
        final AtomicBoolean once;
        final CompositeDisposable set;
        Subscription s;
        volatile boolean done;

        CompletableMergeSubscriber(CompletableObserver actual, int maxConcurrency, boolean delayErrors) {
            this.actual = actual;
            this.maxConcurrency = maxConcurrency;
            this.delayErrors = delayErrors;
            this.set = new CompositeDisposable();
            this.error = new AtomicThrowable();
            this.once = new AtomicBoolean();
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.set.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                if (this.maxConcurrency == Integer.MAX_VALUE) {
                    s.request(Long.MAX_VALUE);
                } else {
                    s.request((long)this.maxConcurrency);
                }
            }
        }

        public void onNext(CompletableSource t) {
            if (this.done) {
                return;
            }
            this.getAndIncrement();
            t.subscribe(new InnerObserver());
        }

        public void onError(Throwable t) {
            if (this.done || !this.error.addThrowable(t)) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.terminate();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.terminate();
        }

        void terminate() {
            Throwable ex;
            if (this.decrementAndGet() == 0) {
                Throwable ex2 = (Throwable)this.error.get();
                if (ex2 == null) {
                    this.actual.onComplete();
                } else {
                    this.actual.onError(this.error.terminate());
                }
            } else if (!this.delayErrors && (ex = (Throwable)this.error.get()) != null && ex != ExceptionHelper.TERMINATED) {
                this.s.cancel();
                this.set.dispose();
                if (this.once.compareAndSet(false, true)) {
                    this.actual.onError(this.error.terminate());
                } else {
                    RxJavaPlugins.onError(ex);
                }
            }
        }

        final class InnerObserver
        implements CompletableObserver {
            Disposable d;
            boolean innerDone;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                this.d = d;
                CompletableMergeSubscriber.this.set.add(d);
            }

            @Override
            public void onError(Throwable e) {
                if (this.innerDone || !CompletableMergeSubscriber.this.error.addThrowable(e)) {
                    RxJavaPlugins.onError(e);
                    return;
                }
                CompletableMergeSubscriber.this.set.delete(this.d);
                this.innerDone = true;
                CompletableMergeSubscriber.this.terminate();
                if (CompletableMergeSubscriber.this.delayErrors && !CompletableMergeSubscriber.this.done) {
                    CompletableMergeSubscriber.this.s.request(1L);
                }
            }

            @Override
            public void onComplete() {
                if (this.innerDone) {
                    return;
                }
                CompletableMergeSubscriber.this.set.delete(this.d);
                this.innerDone = true;
                CompletableMergeSubscriber.this.terminate();
                if (!CompletableMergeSubscriber.this.done) {
                    CompletableMergeSubscriber.this.s.request(1L);
                }
            }
        }
    }
}

