/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;

public final class SingleFlatMap<T, R>
extends Single<R> {
    final SingleSource<? extends T> source;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;

    public SingleFlatMap(SingleSource<? extends T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        this.mapper = mapper;
        this.source = source;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> subscriber) {
        SingleFlatMapCallback<? super T, ? super R> parent = new SingleFlatMapCallback<T, R>(subscriber, this.mapper);
        subscriber.onSubscribe(parent.sd);
        this.source.subscribe(parent);
    }

    static final class SingleFlatMapCallback<T, R>
    implements SingleObserver<T> {
        final SingleObserver<? super R> actual;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;
        final SequentialDisposable sd;

        SingleFlatMapCallback(SingleObserver<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
            this.actual = actual;
            this.mapper = mapper;
            this.sd = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.sd.replace(d);
        }

        @Override
        public void onSuccess(T value) {
            SingleSource<R> o;
            try {
                o = this.mapper.apply(value);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            if (o == null) {
                this.actual.onError(new NullPointerException("The single returned by the mapper is null"));
                return;
            }
            if (this.sd.isDisposed()) {
                return;
            }
            o.subscribe(new SingleObserver<R>(){

                @Override
                public void onSubscribe(Disposable d) {
                    SingleFlatMapCallback.this.sd.replace(d);
                }

                @Override
                public void onSuccess(R value) {
                    SingleFlatMapCallback.this.actual.onSuccess(value);
                }

                @Override
                public void onError(Throwable e) {
                    SingleFlatMapCallback.this.actual.onError(e);
                }
            });
        }

        @Override
        public void onError(Throwable e) {
            this.actual.onError(e);
        }
    }
}

