/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MaybeAmbArray<T>
extends Maybe<T> {
    final MaybeSource<? extends T>[] sources;

    public MaybeAmbArray(MaybeSource<? extends T>[] sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        AmbMaybeObserver<T> parent = new AmbMaybeObserver<T>(observer);
        observer.onSubscribe(parent);
        for (MaybeSource<T> maybeSource : this.sources) {
            if (parent.isDisposed()) {
                return;
            }
            if (maybeSource == null) {
                parent.onError(new NullPointerException("One of the MaybeSources is null"));
                return;
            }
            maybeSource.subscribe(parent);
        }
    }

    static final class AmbMaybeObserver<T>
    extends AtomicBoolean
    implements MaybeObserver<T>,
    Disposable {
        private static final long serialVersionUID = -7044685185359438206L;
        final MaybeObserver<? super T> actual;
        final CompositeDisposable set;

        AmbMaybeObserver(MaybeObserver<? super T> actual) {
            this.actual = actual;
            this.set = new CompositeDisposable();
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
                this.actual.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
                this.actual.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
                this.actual.onComplete();
            }
        }
    }
}

