/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscriptions;

import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public enum SubscriptionHelper implements Subscription
{
    CANCELLED;


    public void request(long n) {
    }

    public void cancel() {
    }

    public static boolean validate(Subscription current, Subscription next) {
        if (next == null) {
            RxJavaPlugins.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return false;
        }
        return true;
    }

    public static void reportSubscriptionSet() {
        RxJavaPlugins.onError(new IllegalStateException("Subscription already set!"));
    }

    public static boolean validate(long n) {
        if (n <= 0L) {
            RxJavaPlugins.onError(new IllegalArgumentException("n > 0 required but it was " + n));
            return false;
        }
        return true;
    }

    public static void reportMoreProduced(long n) {
        RxJavaPlugins.onError(new IllegalStateException("More produced than requested: " + n));
    }

    public static boolean isCancelled(Subscription s) {
        return s == CANCELLED;
    }

    public static boolean set(AtomicReference<Subscription> field, Subscription s) {
        Subscription current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s != null) {
                s.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s));
        if (current != null) {
            current.cancel();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Subscription> field, Subscription s) {
        ObjectHelper.requireNonNull(s, "d is null");
        if (!field.compareAndSet(null, s)) {
            s.cancel();
            if (field.get() != CANCELLED) {
                SubscriptionHelper.reportSubscriptionSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<Subscription> field, Subscription s) {
        Subscription current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s != null) {
                s.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s));
        return true;
    }

    public static boolean cancel(AtomicReference<Subscription> field) {
        Subscription current = field.get();
        if (current != CANCELLED && (current = field.getAndSet(CANCELLED)) != CANCELLED) {
            if (current != null) {
                current.cancel();
            }
            return true;
        }
        return false;
    }

    public static void deferredSetOnce(AtomicReference<Subscription> field, AtomicLong requested, Subscription s) {
        long r;
        if (SubscriptionHelper.setOnce(field, s) && (r = requested.getAndSet(0L)) != 0L) {
            s.request(r);
        }
    }

    public static void deferredRequest(AtomicReference<Subscription> field, AtomicLong requested, long n) {
        Subscription s = field.get();
        if (s != null) {
            s.request(n);
        } else if (SubscriptionHelper.validate(n)) {
            long r;
            BackpressureHelper.add(requested, n);
            s = field.get();
            if (s != null && (r = requested.getAndSet(0L)) != 0L) {
                s.request(r);
            }
        }
    }
}

