/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.flowable;

import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class BlockingSingleSubscriber<T>
extends CountDownLatch
implements Subscriber<T> {
    T value;
    Throwable error;
    Subscription s;
    volatile boolean cancelled;

    public BlockingSingleSubscriber() {
        super(1);
    }

    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.s, s)) {
            this.s = s;
            if (!this.cancelled) {
                s.request(Long.MAX_VALUE);
                if (this.cancelled) {
                    this.s = SubscriptionHelper.CANCELLED;
                    s.cancel();
                }
            }
        }
    }

    public final void onComplete() {
        this.countDown();
    }

    public final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex) {
                Subscription s = this.s;
                this.s = SubscriptionHelper.CANCELLED;
                if (s != null) {
                    s.cancel();
                }
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        if ((e = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(e);
        }
        return this.value;
    }
}

