/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.queue;

import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.util.Pow2;
import java.util.concurrent.atomic.AtomicReferenceArray;

abstract class BaseArrayQueue<E>
extends AtomicReferenceArray<E>
implements SimpleQueue<E> {
    private static final long serialVersionUID = 5238363267841964068L;
    protected final int mask = this.length() - 1;

    public BaseArrayQueue(int capacity) {
        super(Pow2.roundToPowerOfTwo(capacity));
    }

    @Override
    public abstract E poll();

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    protected final int calcElementOffset(long index, int mask) {
        return (int)index & mask;
    }

    protected final int calcElementOffset(long index) {
        return (int)index & this.mask;
    }

    protected final E lvElement(AtomicReferenceArray<E> buffer, int offset) {
        return buffer.get(offset);
    }

    protected final E lpElement(AtomicReferenceArray<E> buffer, int offset) {
        return buffer.get(offset);
    }

    protected final E lpElement(int offset) {
        return this.get(offset);
    }

    protected final void spElement(AtomicReferenceArray<E> buffer, int offset, E value) {
        buffer.lazySet(offset, value);
    }

    protected final void spElement(int offset, E value) {
        this.lazySet(offset, value);
    }

    protected final void soElement(AtomicReferenceArray<E> buffer, int offset, E value) {
        buffer.lazySet(offset, value);
    }

    protected final void soElement(int offset, E value) {
        this.lazySet(offset, value);
    }

    protected final void svElement(AtomicReferenceArray<E> buffer, int offset, E value) {
        buffer.set(offset, value);
    }

    protected final E lvElement(int offset) {
        return this.get(offset);
    }
}

