/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class SingleUsing<T, U>
extends Single<T> {
    final Callable<U> resourceSupplier;
    final Function<? super U, ? extends SingleSource<? extends T>> singleFunction;
    final Consumer<? super U> disposer;
    final boolean eager;

    public SingleUsing(Callable<U> resourceSupplier, Function<? super U, ? extends SingleSource<? extends T>> singleFunction, Consumer<? super U> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.singleFunction = singleFunction;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        SingleSource<T> s1;
        U resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, s);
            return;
        }
        try {
            s1 = ObjectHelper.requireNonNull(this.singleFunction.apply(resource), "The singleFunction returned a null SingleSource");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, s);
            return;
        }
        s1.subscribe(new SingleObserver<T>(){

            @Override
            public void onSubscribe(Disposable d) {
                if (SingleUsing.this.eager) {
                    CompositeDisposable set = new CompositeDisposable();
                    set.add(d);
                    set.add(Disposables.fromRunnable(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SingleUsing.this.disposer.accept(resource);
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal(e);
                                RxJavaPlugins.onError(e);
                            }
                        }
                    }));
                    s.onSubscribe(set);
                } else {
                    s.onSubscribe(d);
                }
            }

            @Override
            public void onSuccess(T value) {
                if (SingleUsing.this.eager) {
                    try {
                        SingleUsing.this.disposer.accept(resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        s.onError(e);
                        return;
                    }
                }
                s.onSuccess(value);
                if (!SingleUsing.this.eager) {
                    try {
                        SingleUsing.this.disposer.accept(resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        RxJavaPlugins.onError(e);
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                if (SingleUsing.this.eager) {
                    try {
                        SingleUsing.this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        e = new CompositeException(ex, e);
                    }
                }
                s.onError(e);
                if (!SingleUsing.this.eager) {
                    try {
                        SingleUsing.this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        RxJavaPlugins.onError(ex);
                    }
                }
            }
        });
    }
}

