/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableSkipUntil<T, U>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<U> other;

    public ObservableSkipUntil(ObservableSource<T> source, ObservableSource<U> other) {
        super(source);
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> child) {
        final SerializedObserver<? super T> serial = new SerializedObserver<T>(child);
        final ArrayCompositeDisposable frc = new ArrayCompositeDisposable(2);
        final SkipUntilSubscriber<? super T> sus = new SkipUntilSubscriber<T>(serial, frc);
        this.other.subscribe(new Observer<U>(){
            Disposable s;

            @Override
            public void onSubscribe(Disposable s) {
                if (DisposableHelper.validate(this.s, s)) {
                    this.s = s;
                    frc.setResource(1, s);
                }
            }

            @Override
            public void onNext(U t) {
                this.s.dispose();
                sus.notSkipping = true;
            }

            @Override
            public void onError(Throwable t) {
                frc.dispose();
                if (sus.compareAndSet(false, true)) {
                    EmptyDisposable.error(t, serial);
                } else {
                    serial.onError(t);
                }
            }

            @Override
            public void onComplete() {
                sus.notSkipping = true;
            }
        });
        this.source.subscribe(sus);
    }

    static final class SkipUntilSubscriber<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -1113667257122396604L;
        final Observer<? super T> actual;
        final ArrayCompositeDisposable frc;
        Disposable s;
        volatile boolean notSkipping;
        boolean notSkippingLocal;

        public SkipUntilSubscriber(Observer<? super T> actual, ArrayCompositeDisposable frc) {
            this.actual = actual;
            this.frc = frc;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                if (this.frc.setResource(0, s) && this.compareAndSet(false, true)) {
                    this.actual.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (this.notSkippingLocal) {
                this.actual.onNext(t);
            } else if (this.notSkipping) {
                this.notSkippingLocal = true;
                this.actual.onNext(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.frc.dispose();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.frc.dispose();
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.frc.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.frc.isDisposed();
        }
    }
}

