/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.UnicastSubject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableGroupJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends AbstractObservableWithUpstream<TLeft, R> {
    final ObservableSource<? extends TRight> other;
    final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector;

    public ObservableGroupJoin(ObservableSource<TLeft> source, ObservableSource<? extends TRight> other, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector) {
        super(source);
        this.other = other;
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.resultSelector = resultSelector;
    }

    @Override
    protected void subscribeActual(Observer<? super R> s) {
        GroupJoinSubscription parent = new GroupJoinSubscription(s, this.leftEnd, this.rightEnd, this.resultSelector);
        s.onSubscribe(parent);
        LeftRightSubscriber left = new LeftRightSubscriber(parent, true);
        parent.disposables.add(left);
        LeftRightSubscriber right = new LeftRightSubscriber(parent, false);
        parent.disposables.add(right);
        this.source.subscribe(left);
        this.other.subscribe(right);
    }

    static final class LeftRightEndSubscriber
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = 1883890389173668373L;
        final JoinSupport parent;
        final boolean isLeft;
        final int index;

        public LeftRightEndSubscriber(JoinSupport parent, boolean isLeft, int index) {
            this.parent = parent;
            this.isLeft = isLeft;
            this.index = index;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable s) {
            DisposableHelper.setOnce(this, s);
        }

        @Override
        public void onNext(Object t) {
            if (DisposableHelper.dispose(this)) {
                this.parent.innerClose(this.isLeft, this);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            this.parent.innerClose(this.isLeft, this);
        }
    }

    static final class LeftRightSubscriber
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = 1883890389173668373L;
        final JoinSupport parent;
        final boolean isLeft;

        public LeftRightSubscriber(JoinSupport parent, boolean isLeft) {
            this.parent = parent;
            this.isLeft = isLeft;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable s) {
            DisposableHelper.setOnce(this, s);
        }

        @Override
        public void onNext(Object t) {
            this.parent.innerValue(this.isLeft, t);
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this);
        }
    }

    static final class GroupJoinSubscription<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements Disposable,
    JoinSupport {
        private static final long serialVersionUID = -6071216598687999801L;
        final Observer<? super R> actual;
        final SpscLinkedArrayQueue<Object> queue;
        final CompositeDisposable disposables;
        final Map<Integer, UnicastSubject<TRight>> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
        final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
        final BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        public GroupJoinSubscription(Observer<? super R> actual, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector) {
            this.actual = actual;
            this.disposables = new CompositeDisposable();
            this.queue = new SpscLinkedArrayQueue(Observable.bufferSize());
            this.lefts = new LinkedHashMap<Integer, UnicastSubject<TRight>>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void dispose() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(Observer<?> a) {
            Throwable ex = ExceptionHelper.terminate(this.error);
            for (UnicastSubject<TRight> up : this.lefts.values()) {
                up.onError(ex);
            }
            this.lefts.clear();
            this.rights.clear();
            a.onError(ex);
        }

        void fail(Throwable exc, Observer<?> a, SpscLinkedArrayQueue<?> q) {
            Exceptions.throwIfFatal(exc);
            ExceptionHelper.addThrowable(this.error, exc);
            q.clear();
            this.cancelAll();
            this.errorAll(a);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<Object> q = this.queue;
            Observer<R> a = this.actual;
            block6: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                Throwable ex = this.error.get();
                if (ex != null) {
                    q.clear();
                    this.cancelAll();
                    this.errorAll(a);
                    return;
                }
                boolean d = this.active.get() == 0;
                Integer mode = (Integer)q.poll();
                boolean bl = empty = mode == null;
                if (d && empty) {
                    for (UnicastSubject<TRight> up : this.lefts.values()) {
                        up.onComplete();
                    }
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a.onComplete();
                    return;
                }
                if (!empty) {
                    LeftRightEndSubscriber end;
                    Object val = q.poll();
                    if (mode == LEFT_VALUE) {
                        R w;
                        ObservableSource<TLeftEnd> p;
                        int idx;
                        Object left = val;
                        UnicastSubject<TRight> up = UnicastSubject.create();
                        ++this.leftIndex;
                        this.lefts.put(idx, up);
                        try {
                            p = ObjectHelper.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a, q);
                            return;
                        }
                        LeftRightEndSubscriber end2 = new LeftRightEndSubscriber(this, true, idx);
                        this.disposables.add(end2);
                        p.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        try {
                            w = ObjectHelper.requireNonNull(this.resultSelector.apply(left, up), "The resultSelector returned a null value");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a, q);
                            return;
                        }
                        a.onNext(w);
                        Iterator<TRight> i$ = this.rights.values().iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block6;
                            TRight right = i$.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        ObservableSource<TRightEnd> p;
                        int idx;
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p = ObjectHelper.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a, q);
                            return;
                        }
                        LeftRightEndSubscriber end3 = new LeftRightEndSubscriber(this, false, idx);
                        this.disposables.add(end3);
                        p.subscribe(end3);
                        ex = this.error.get();
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        Iterator<UnicastSubject<TRight>> i$ = this.lefts.values().iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block6;
                            UnicastSubject<TRight> up = i$.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (LeftRightEndSubscriber)val;
                        UnicastSubject<TRight> up = this.lefts.remove(end.index);
                        this.disposables.remove(end);
                        if (up == null) continue;
                        up.onComplete();
                        continue;
                    }
                    if (mode != RIGHT_CLOSE) continue;
                    end = (LeftRightEndSubscriber)val;
                    this.rights.remove(end.index);
                    this.disposables.remove(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (ExceptionHelper.addThrowable(this.error, ex)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void innerComplete(LeftRightSubscriber sender) {
            this.disposables.delete(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o) {
            GroupJoinSubscription groupJoinSubscription = this;
            synchronized (groupJoinSubscription) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, LeftRightEndSubscriber index) {
            GroupJoinSubscription groupJoinSubscription = this;
            synchronized (groupJoinSubscription) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (ExceptionHelper.addThrowable(this.error, ex)) {
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }
    }

    static interface JoinSupport {
        public void innerError(Throwable var1);

        public void innerComplete(LeftRightSubscriber var1);

        public void innerValue(boolean var1, Object var2);

        public void innerClose(boolean var1, LeftRightEndSubscriber var2);

        public void innerCloseError(Throwable var1);
    }
}

