/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;

    public ObservableFlatMap(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super U> t) {
        if (ObservableScalarXMap.tryScalarXMapSubscribe(this.source, t, this.mapper)) {
            return;
        }
        this.source.subscribe(new MergeSubscriber<T, U>(t, this.mapper, this.delayErrors, this.maxConcurrency, this.bufferSize));
    }

    static final class RejectingQueue<T>
    implements SimpleQueue<T> {
        RejectingQueue() {
        }

        @Override
        public boolean offer(T e) {
            return false;
        }

        @Override
        public T poll() {
            return null;
        }

        @Override
        public boolean offer(T v1, T v2) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }
    }

    static final class InnerSubscriber<T, U>
    extends AtomicReference<Disposable>
    implements Observer<U>,
    Disposable {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeSubscriber<T, U> parent;
        volatile boolean done;
        volatile SimpleQueue<U> queue;
        int fusionMode;

        public InnerSubscriber(MergeSubscriber<T, U> parent, long id) {
            this.id = id;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.setOnce(this, s) && s instanceof QueueDisposable) {
                QueueDisposable qd = (QueueDisposable)s;
                int m = qd.requestFusion(3);
                if (m == 1) {
                    this.fusionMode = m;
                    this.queue = qd;
                    this.done = true;
                    this.parent.drain();
                    return;
                }
                if (m == 2) {
                    this.fusionMode = m;
                    this.queue = qd;
                }
            }
        }

        @Override
        public void onNext(U t) {
            if (this.fusionMode == 0) {
                this.parent.tryEmit(t, this);
            } else {
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.parent.getErrorQueue().offer(t);
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }
    }

    static final class MergeSubscriber<T, U>
    extends AtomicInteger
    implements Disposable,
    Observer<T> {
        private static final long serialVersionUID = -2117620485640801370L;
        final Observer<? super U> actual;
        final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile SimpleQueue<U> queue;
        volatile boolean done;
        final AtomicReference<SimpleQueue<Throwable>> errors = new AtomicReference();
        static final SimpleQueue<Throwable> ERRORS_CLOSED = new RejectingQueue<Throwable>();
        volatile boolean cancelled;
        final AtomicReference<InnerSubscriber<?, ?>[]> subscribers;
        static final InnerSubscriber<?, ?>[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber<?, ?>[] CANCELLED = new InnerSubscriber[0];
        Disposable s;
        long uniqueId;
        long lastId;
        int lastIndex;
        Queue<ObservableSource<? extends U>> sources;
        int wip;

        public MergeSubscriber(Observer<? super U> actual, Function<? super T, ? extends ObservableSource<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            if (maxConcurrency != Integer.MAX_VALUE) {
                this.sources = new ArrayDeque<ObservableSource<? extends U>>(maxConcurrency);
            }
            this.subscribers = new AtomicReference<InnerSubscriber<?, ?>[]>(EMPTY);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            ObservableSource<? extends U> p;
            if (this.done) {
                return;
            }
            try {
                p = this.mapper.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.onError(e);
                return;
            }
            if (p instanceof Callable) {
                this.tryEmitScalar((Callable)((Object)p));
            } else if (this.maxConcurrency == Integer.MAX_VALUE) {
                this.subscribeInner(p);
            } else {
                MergeSubscriber mergeSubscriber = this;
                synchronized (mergeSubscriber) {
                    if (this.wip == this.maxConcurrency) {
                        this.sources.offer(p);
                        return;
                    }
                    ++this.wip;
                }
                this.subscribeInner(p);
            }
        }

        void subscribeInner(ObservableSource<? extends U> p) {
            InnerSubscriber inner = new InnerSubscriber(this, this.uniqueId++);
            this.addInner(inner);
            p.subscribe(inner);
        }

        void addInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber[] b;
            InnerSubscriber<?, ?>[] a;
            do {
                if ((a = this.subscribers.get()) == CANCELLED) {
                    inner.dispose();
                    return;
                }
                int n = a.length;
                b = new InnerSubscriber[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = inner;
            } while (!this.subscribers.compareAndSet(a, b));
        }

        void removeInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber<?, ?>[] b;
            InnerSubscriber<?, ?>[] a;
            do {
                if ((a = this.subscribers.get()) == CANCELLED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != inner) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new InnerSubscriber[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        SimpleQueue<U> getMainQueue() {
            SimpleQueue<U> q = this.queue;
            if (q == null) {
                q = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                this.queue = q;
            }
            return q;
        }

        void tryEmitScalar(Callable<? extends U> value) {
            U u;
            try {
                u = value.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.getErrorQueue().offer(ex);
                this.drain();
                return;
            }
            if (u == null) {
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.actual.onNext(u);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue<U> q = this.getMainQueue();
                if (!q.offer(u)) {
                    this.onError(new IllegalStateException("Scalar queue full?!"));
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        SimpleQueue<U> getInnerQueue(InnerSubscriber<T, U> inner) {
            SimpleQueue q = inner.queue;
            if (q == null) {
                inner.queue = q = new SpscArrayQueue(this.bufferSize);
            }
            return q;
        }

        void tryEmit(U value, InnerSubscriber<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.actual.onNext(value);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue q = inner.queue;
                if (q == null) {
                    q = new SpscLinkedArrayQueue(this.bufferSize);
                    inner.queue = q;
                }
                if (!q.offer(value)) {
                    this.onError(new MissingBackpressureException("Inner queue full?!"));
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                return;
            }
            this.getErrorQueue().offer(t);
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.s.dispose();
                    this.unsubscribe();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drainLoop() {
            Observer<U> child = this.actual;
            int missed = 1;
            while (true) {
                if (this.checkTerminate()) {
                    return;
                }
                SimpleQueue<U> svq = this.queue;
                if (svq != null) {
                    Object o;
                    block8: do {
                        o = null;
                        while (true) {
                            if (this.checkTerminate()) {
                                return;
                            }
                            try {
                                o = svq.poll();
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                this.getErrorQueue().offer(ex);
                                continue;
                            }
                            if (o == null) continue block8;
                            child.onNext(o);
                        }
                    } while (o != null);
                }
                boolean d = this.done;
                svq = this.queue;
                InnerSubscriber<?, ?>[] inner = this.subscribers.get();
                int n = inner.length;
                if (d && (svq == null || svq.isEmpty()) && n == 0) {
                    SimpleQueue<Throwable> e = this.errors.get();
                    if (e == null || e.isEmpty()) {
                        child.onComplete();
                    } else {
                        this.reportError(e);
                    }
                    return;
                }
                boolean innerCompleted = false;
                if (n != 0) {
                    int i;
                    int j;
                    long startId = this.lastId;
                    int index = this.lastIndex;
                    if (n <= index || inner[index].id != startId) {
                        if (n <= index) {
                            index = 0;
                        }
                        j = index;
                        for (i = 0; i < n && inner[j].id != startId; ++i) {
                            if (++j != n) continue;
                            j = 0;
                        }
                        index = j;
                        this.lastIndex = j;
                        this.lastId = inner[j].id;
                    }
                    j = index;
                    for (i = 0; i < n; ++i) {
                        if (this.checkTerminate()) {
                            return;
                        }
                        InnerSubscriber<?, ?> is = inner[j];
                        Object o = null;
                        while (true) {
                            if (this.checkTerminate()) {
                                return;
                            }
                            SimpleQueue q = is.queue;
                            if (q != null) {
                                try {
                                    o = q.poll();
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal(ex);
                                    this.getErrorQueue().offer(ex);
                                    continue;
                                }
                                if (o != null) {
                                    child.onNext(o);
                                    continue;
                                }
                            }
                            if (o == null) break;
                        }
                        boolean innerDone = is.done;
                        SimpleQueue innerQueue = is.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is);
                            if (this.checkTerminate()) {
                                return;
                            }
                            innerCompleted = true;
                        }
                        if (++j != n) continue;
                        j = 0;
                    }
                    this.lastIndex = j;
                    this.lastId = inner[j].id;
                }
                if (innerCompleted) {
                    ObservableSource<? extends U> p;
                    if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                    MergeSubscriber mergeSubscriber = this;
                    synchronized (mergeSubscriber) {
                        p = this.sources.poll();
                        if (p == null) {
                            --this.wip;
                            continue;
                        }
                    }
                    this.subscribeInner(p);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkTerminate() {
            if (this.cancelled) {
                this.s.dispose();
                this.unsubscribe();
                return true;
            }
            SimpleQueue<Throwable> e = this.errors.get();
            if (!this.delayErrors && e != null && !e.isEmpty()) {
                try {
                    this.reportError(e);
                }
                finally {
                    this.unsubscribe();
                }
                return true;
            }
            return false;
        }

        void reportError(SimpleQueue<Throwable> q) {
            CompositeException composite = null;
            Throwable ex = null;
            int count = 0;
            while (true) {
                Throwable t;
                try {
                    t = q.poll();
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    if (composite == null) {
                        composite = new CompositeException(new Throwable[]{exc});
                    }
                    composite.suppress(exc);
                    break;
                }
                if (t == null) break;
                if (count == 0) {
                    ex = t;
                } else {
                    if (composite == null) {
                        composite = new CompositeException(new Throwable[]{ex});
                    }
                    composite.suppress(t);
                }
                ++count;
            }
            if (composite != null) {
                this.actual.onError(composite);
            } else {
                this.actual.onError(ex);
            }
        }

        void unsubscribe() {
            InnerSubscriber<?, ?>[] a = this.subscribers.get();
            if (a != CANCELLED && (a = this.subscribers.getAndSet(CANCELLED)) != CANCELLED) {
                this.errors.getAndSet(ERRORS_CLOSED);
                for (InnerSubscriber<?, ?> inner : a) {
                    inner.dispose();
                }
            }
        }

        SimpleQueue<Throwable> getErrorQueue() {
            SimpleQueue<Throwable> q;
            do {
                if ((q = this.errors.get()) == null) continue;
                return q;
            } while (!this.errors.compareAndSet(null, q = new MpscLinkedQueue<Throwable>()));
            return q;
        }
    }
}

