/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeFromObservable<T>
extends Maybe<T>
implements HasUpstreamObservableSource<T> {
    final ObservableSource<T> source;

    public MaybeFromObservable(ObservableSource<T> source) {
        this.source = source;
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new FromObservableToMaybeObserver<T>(observer));
    }

    static final class FromObservableToMaybeObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -8017657973346356002L;
        final MaybeObserver<? super T> actual;
        T value;

        public FromObservableToMaybeObserver(MaybeObserver<? super T> observer) {
            this.actual = observer;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.setOnce(this, s)) {
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.isDisposed()) {
                if (this.value != null) {
                    ((Disposable)this.get()).dispose();
                    this.onError(new IndexOutOfBoundsException("The source ObservableSource produced more than one item"));
                } else {
                    this.value = t;
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.isDisposed()) {
                this.value = null;
                this.lazySet(DisposableHelper.DISPOSED);
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.isDisposed()) {
                this.lazySet(DisposableHelper.DISPOSED);
                T v = this.value;
                if (v == null) {
                    this.actual.onComplete();
                } else {
                    this.value = null;
                    this.actual.onSuccess(v);
                }
            }
        }
    }
}

