/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRepeatUntil<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BooleanSupplier until;

    public FlowableRepeatUntil(Publisher<T> source, BooleanSupplier until) {
        super(source);
        this.until = until;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        SubscriptionArbiter sa = new SubscriptionArbiter();
        s.onSubscribe((Subscription)sa);
        RepeatSubscriber<T> rs = new RepeatSubscriber<T>(s, this.until, sa, this.source);
        rs.subscribeNext();
    }

    static final class RepeatSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> actual;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        final BooleanSupplier stop;

        public RepeatSubscriber(Subscriber<? super T> actual, BooleanSupplier until, SubscriptionArbiter sa, Publisher<? extends T> source) {
            this.actual = actual;
            this.sa = sa;
            this.source = source;
            this.stop = until;
        }

        public void onSubscribe(Subscription s) {
            this.sa.setSubscription(s);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
            this.sa.produced(1L);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            boolean b;
            try {
                b = this.stop.getAsBoolean();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            if (b) {
                this.actual.onComplete();
            } else {
                this.subscribeNext();
            }
        }

        void subscribeNext() {
            block1: {
                if (this.getAndIncrement() != 0) break block1;
                int missed = 1;
                do {
                    this.source.subscribe((Subscriber)this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

