/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRepeat<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long count;

    public FlowableRepeat(Publisher<T> source, long count) {
        super(source);
        this.count = count;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        SubscriptionArbiter sa = new SubscriptionArbiter();
        s.onSubscribe((Subscription)sa);
        RepeatSubscriber<T> rs = new RepeatSubscriber<T>(s, this.count != Long.MAX_VALUE ? this.count - 1L : Long.MAX_VALUE, sa, this.source);
        rs.subscribeNext();
    }

    static final class RepeatSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> actual;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        long remaining;

        public RepeatSubscriber(Subscriber<? super T> actual, long count, SubscriptionArbiter sa, Publisher<? extends T> source) {
            this.actual = actual;
            this.sa = sa;
            this.source = source;
            this.remaining = count;
        }

        public void onSubscribe(Subscription s) {
            this.sa.setSubscription(s);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
            this.sa.produced(1L);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r != 0L) {
                this.subscribeNext();
            } else {
                this.actual.onComplete();
            }
        }

        void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    this.source.subscribe((Subscriber)this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

