/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDistinct<T, K>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final Callable<? extends Predicate<? super K>> predicateSupplier;

    public FlowableDistinct(Publisher<T> source, Function<? super T, K> keySelector, Callable<? extends Predicate<? super K>> predicateSupplier) {
        super(source);
        this.predicateSupplier = predicateSupplier;
        this.keySelector = keySelector;
    }

    public static <T, K> Flowable<T> withCollection(Publisher<T> source, Function<? super T, K> keySelector, final Callable<? extends Collection<? super K>> collectionSupplier) {
        Callable p = new Callable<Predicate<K>>(){

            @Override
            public Predicate<K> call() throws Exception {
                final Collection coll = (Collection)collectionSupplier.call();
                return new Predicate<K>(){

                    @Override
                    public boolean test(K t) {
                        if (t == null) {
                            coll.clear();
                            return true;
                        }
                        return coll.add(t);
                    }
                };
            }
        };
        return RxJavaPlugins.onAssembly(new FlowableDistinct<T, K>(source, keySelector, p));
    }

    public static <T> Flowable<T> untilChanged(Publisher<T> source) {
        Callable p = new Callable<Predicate<T>>(){
            Object last;

            @Override
            public Predicate<T> call() {
                return new Predicate<T>(){

                    @Override
                    public boolean test(T t) {
                        if (t == null) {
                            last = null;
                            return true;
                        }
                        Object o = last;
                        last = t;
                        return !ObjectHelper.equals(o, t);
                    }
                };
            }
        };
        return RxJavaPlugins.onAssembly(new FlowableDistinct(source, Functions.identity(), p));
    }

    public static <T, K> Flowable<T> untilChanged(Publisher<T> source, Function<? super T, K> keySelector) {
        Callable p = new Callable<Predicate<K>>(){
            Object last;

            @Override
            public Predicate<K> call() {
                return new Predicate<K>(){

                    @Override
                    public boolean test(K t) {
                        if (t == null) {
                            last = null;
                            return true;
                        }
                        Object o = last;
                        last = t;
                        return !ObjectHelper.equals(o, t);
                    }
                };
            }
        };
        return RxJavaPlugins.onAssembly(new FlowableDistinct<T, K>(source, keySelector, p));
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        Predicate<? super K> coll;
        try {
            coll = this.predicateSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s);
            return;
        }
        if (coll == null) {
            EmptySubscription.error(new NullPointerException("predicateSupplier returned null"), s);
            return;
        }
        this.source.subscribe(new DistinctSubscriber<T, K>(s, this.keySelector, coll));
    }

    static final class DistinctSubscriber<T, K>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final Predicate<? super K> predicate;
        final Function<? super T, K> keySelector;
        Subscription s;

        public DistinctSubscriber(Subscriber<? super T> actual, Function<? super T, K> keySelector, Predicate<? super K> predicate) {
            this.actual = actual;
            this.keySelector = keySelector;
            this.predicate = predicate;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            boolean b;
            K key;
            try {
                key = this.keySelector.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.cancel();
                this.actual.onError(e);
                return;
            }
            if (key == null) {
                this.s.cancel();
                this.actual.onError((Throwable)new NullPointerException("Null key supplied"));
                return;
            }
            try {
                b = this.predicate.test(key);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.cancel();
                this.actual.onError(e);
                return;
            }
            if (b) {
                this.actual.onNext(t);
            } else {
                this.s.request(1L);
            }
        }

        public void onError(Throwable t) {
            try {
                this.predicate.test(null);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError((Throwable)new CompositeException(e, t));
                return;
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            try {
                this.predicate.test(null);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

