/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Notification;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.subscribers.DisposableSubscriber;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;

public enum BlockingFlowableLatest {


    public static <T> Iterable<T> latest(final Publisher<? extends T> source) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                LatestObserverIterator lio = new LatestObserverIterator();
                Flowable.fromPublisher(source).materialize().subscribe(lio);
                return lio;
            }
        };
    }

    static final class LatestObserverIterator<T>
    extends DisposableSubscriber<Notification<T>>
    implements Iterator<T> {
        final Semaphore notify = new Semaphore(0);
        final AtomicReference<Notification<T>> value = new AtomicReference();
        Notification<T> iteratorNotification;

        LatestObserverIterator() {
        }

        public void onNext(Notification<T> args) {
            boolean wasNotAvailable;
            boolean bl = wasNotAvailable = this.value.getAndSet(args) == null;
            if (wasNotAvailable) {
                this.notify.release();
            }
        }

        public void onError(Throwable e) {
        }

        public void onComplete() {
        }

        @Override
        public boolean hasNext() {
            if (this.iteratorNotification != null && this.iteratorNotification.isOnError()) {
                throw ExceptionHelper.wrapOrThrow(this.iteratorNotification.getError());
            }
            if ((this.iteratorNotification == null || this.iteratorNotification.isOnNext()) && this.iteratorNotification == null) {
                Notification n;
                try {
                    this.notify.acquire();
                }
                catch (InterruptedException ex) {
                    this.dispose();
                    Thread.currentThread().interrupt();
                    this.iteratorNotification = Notification.createOnError(ex);
                    throw ExceptionHelper.wrapOrThrow(ex);
                }
                this.iteratorNotification = n = (Notification)this.value.getAndSet(null);
                if (n.isOnError()) {
                    throw ExceptionHelper.wrapOrThrow(n.getError());
                }
            }
            return this.iteratorNotification.isOnNext();
        }

        @Override
        public T next() {
            if (this.hasNext() && this.iteratorNotification.isOnNext()) {
                T v = this.iteratorNotification.getValue();
                this.iteratorNotification = null;
                return v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator.");
        }
    }
}

