/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subscribers;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class DisposableSubscriber<T>
implements Subscriber<T>,
Disposable {
    final AtomicReference<Subscription> s = new AtomicReference();

    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.s, s)) {
            this.onStart();
        }
    }

    protected final Subscription subscription() {
        return this.s.get();
    }

    protected void onStart() {
        this.s.get().request(Long.MAX_VALUE);
    }

    protected final void request(long n) {
        this.s.get().request(n);
    }

    protected final void cancel() {
        this.dispose();
    }

    @Override
    public final boolean isDisposed() {
        return this.s.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public final void dispose() {
        SubscriptionHelper.cancel(this.s);
    }
}

