/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class UnicastSubject<T>
extends Subject<T> {
    final State<T> state;

    public static <T> UnicastSubject<T> create() {
        return UnicastSubject.create(16);
    }

    public static <T> UnicastSubject<T> create(int capacityHint) {
        return UnicastSubject.create(capacityHint, null);
    }

    public static <T> UnicastSubject<T> create(int capacityHint, Runnable onCancelled) {
        State state = new State(capacityHint, onCancelled);
        return new UnicastSubject(state);
    }

    protected UnicastSubject(State<T> state) {
        this.state = state;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.state.subscribe(observer);
    }

    @Override
    public void onSubscribe(Disposable s) {
        this.state.onSubscribe(s);
    }

    @Override
    public void onNext(T t) {
        this.state.onNext(t);
    }

    @Override
    public void onError(Throwable t) {
        this.state.onError(t);
    }

    @Override
    public void onComplete() {
        this.state.onComplete();
    }

    @Override
    public boolean hasObservers() {
        return this.state.subscriber.get() != null;
    }

    @Override
    public Throwable getThrowable() {
        State<T> s = this.state;
        if (s.done) {
            return s.error;
        }
        return null;
    }

    @Override
    public boolean hasThrowable() {
        State<T> s = this.state;
        return s.done && s.error != null;
    }

    @Override
    public boolean hasComplete() {
        State<T> s = this.state;
        return s.done && s.error == null;
    }

    static final class State<T>
    extends StatePad0
    implements ObservableSource<T>,
    Disposable,
    Observer<T> {
        private static final long serialVersionUID = 5058617037583835632L;
        final SpscLinkedArrayQueue<T> queue;
        final AtomicReference<Observer<? super T>> subscriber = new AtomicReference();
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        final AtomicBoolean once = new AtomicBoolean();
        Runnable onCancelled;

        public State(int capacityHint, Runnable onCancelled) {
            this.onCancelled = onCancelled;
            this.queue = new SpscLinkedArrayQueue(capacityHint);
        }

        @Override
        public void subscribe(Observer<? super T> s) {
            if (!this.once.get() && this.once.compareAndSet(false, true)) {
                s.onSubscribe(this);
                this.subscriber.lazySet(s);
                this.drain();
            } else {
                EmptyDisposable.error((Throwable)new IllegalStateException("Only a single subscriber allowed."), s);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.clear(this.queue);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void notifyOnCancelled() {
            Runnable r = this.onCancelled;
            this.onCancelled = null;
            if (r != null) {
                r.run();
            }
        }

        void clear(SimpleQueue<?> q) {
            this.subscriber.lazySet(null);
            q.clear();
            this.notifyOnCancelled();
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (this.done || this.cancelled) {
                s.dispose();
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done || this.cancelled) {
                return;
            }
            if (t == null) {
                this.onError(new NullPointerException());
                return;
            }
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done || this.cancelled) {
                return;
            }
            if (t == null) {
                t = new NullPointerException();
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (this.done || this.cancelled) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            SpscLinkedArrayQueue<T> q = this.queue;
            Observer<T> a = this.subscriber.get();
            int missed = 1;
            while (true) {
                if (this.cancelled) {
                    this.clear(q);
                    this.notifyOnCancelled();
                    return;
                }
                if (a != null) {
                    boolean d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        this.subscriber.lazySet(null);
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    while (true) {
                        if (this.cancelled) {
                            this.clear(q);
                            this.notifyOnCancelled();
                            return;
                        }
                        d = this.done;
                        T v = this.queue.poll();
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            this.subscriber.lazySet(null);
                            Throwable ex = this.error;
                            if (ex != null) {
                                a.onError(ex);
                            } else {
                                a.onComplete();
                            }
                            return;
                        }
                        if (empty) break;
                        a.onNext(v);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (a != null) continue;
                a = this.subscriber.get();
            }
        }
    }

    static abstract class StatePad0
    extends AtomicInteger {
        private static final long serialVersionUID = 7779228232971173701L;
        volatile long p1a;
        volatile long p2a;
        volatile long p3a;
        volatile long p4a;
        volatile long p5a;
        volatile long p6a;
        volatile long p7a;
        volatile long p8a;
        volatile long p9a;
        volatile long p10a;
        volatile long p11a;
        volatile long p12a;
        volatile long p13a;
        volatile long p14a;
        volatile long p15a;

        StatePad0() {
        }
    }
}

