/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observers;

import io.reactivex.Notification;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class TestObserver<T>
implements Observer<T>,
Disposable {
    private final Observer<? super T> actual;
    private final CountDownLatch done;
    private final List<T> values;
    private final List<Throwable> errors;
    private long completions;
    private Thread lastThread;
    private volatile boolean cancelled;
    private final AtomicReference<Disposable> subscription = new AtomicReference();
    private boolean checkSubscriptionOnce;
    private int initialFusionMode;
    private int establishedFusionMode;
    private QueueDisposable<T> qs;

    public static <T> TestObserver<T> create() {
        return new TestObserver<T>();
    }

    public static <T> TestObserver<T> create(Observer<? super T> delegate) {
        return new TestObserver<T>(delegate);
    }

    public TestObserver() {
        this(EmptyObserver.INSTANCE);
    }

    public TestObserver(Observer<? super T> actual) {
        this.actual = actual;
        this.values = new ArrayList<T>();
        this.errors = new ArrayList<Throwable>();
        this.done = new CountDownLatch(1);
    }

    @Override
    public void onSubscribe(Disposable s) {
        this.lastThread = Thread.currentThread();
        if (s == null) {
            this.errors.add(new NullPointerException("onSubscribe received a null Subscription"));
            return;
        }
        if (!this.subscription.compareAndSet(null, s)) {
            s.dispose();
            if (this.subscription.get() != DisposableHelper.DISPOSED) {
                this.errors.add(new NullPointerException("onSubscribe received multiple subscriptions: " + s));
            }
            return;
        }
        if (this.cancelled) {
            s.dispose();
        }
        if (this.initialFusionMode != 0 && s instanceof QueueDisposable) {
            int m;
            this.qs = (QueueDisposable)s;
            this.establishedFusionMode = m = this.qs.requestFusion(this.initialFusionMode);
            if (m == 1) {
                this.checkSubscriptionOnce = true;
                this.lastThread = Thread.currentThread();
                try {
                    Object t;
                    while ((t = this.qs.poll()) != null) {
                        this.values.add(t);
                    }
                    ++this.completions;
                }
                catch (Throwable ex) {
                    this.errors.add(ex);
                }
                return;
            }
        }
        if (this.cancelled) {
            return;
        }
        this.actual.onSubscribe(s);
    }

    @Override
    public void onNext(T t) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        this.lastThread = Thread.currentThread();
        if (this.establishedFusionMode == 2) {
            try {
                while ((t = this.qs.poll()) != null) {
                    this.values.add(t);
                }
            }
            catch (Throwable ex) {
                this.errors.add(ex);
            }
            return;
        }
        this.values.add(t);
        if (t == null) {
            this.errors.add(new NullPointerException("onNext received a null Subscription"));
        }
        this.actual.onNext(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            this.errors.add(t);
            if (t == null) {
                this.errors.add(new NullPointerException("onError received a null Subscription"));
            }
            this.actual.onError(t);
        }
        finally {
            this.done.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            ++this.completions;
            this.actual.onComplete();
        }
        finally {
            this.done.countDown();
        }
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    public final void cancel() {
        this.dispose();
    }

    @Override
    public final void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            DisposableHelper.dispose(this.subscription);
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.cancelled;
    }

    public final Thread lastThread() {
        return this.lastThread;
    }

    public final List<T> values() {
        return this.values;
    }

    public final List<Throwable> errors() {
        return this.errors;
    }

    public final long completions() {
        return this.completions;
    }

    public final boolean isTerminated() {
        return this.done.getCount() == 0L;
    }

    public final int valueCount() {
        return this.values.size();
    }

    public final int errorCount() {
        return this.errors.size();
    }

    public final boolean hasSubscription() {
        return this.subscription.get() != null;
    }

    public final TestObserver<T> await() throws InterruptedException {
        if (this.done.getCount() == 0L) {
            return this;
        }
        this.done.await();
        return this;
    }

    public final boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.done.getCount() == 0L || this.done.await(time, unit);
    }

    private void fail(String message) {
        StringBuilder b = new StringBuilder(64 + message.length());
        b.append(message);
        b.append(" (").append("latch = ").append(this.done.getCount()).append(", ").append("values = ").append(this.values.size()).append(", ").append("errors = ").append(this.errors.size()).append(", ").append("completions = ").append(this.completions).append(')');
        AssertionError ae = new AssertionError((Object)b.toString());
        CompositeException ce = new CompositeException();
        for (Throwable e : this.errors) {
            if (e == null) {
                ce.suppress(new NullPointerException("Throwable was null!"));
                continue;
            }
            ce.suppress(e);
        }
        if (!ce.isEmpty()) {
            ((Throwable)((Object)ae)).initCause(ce);
        }
        throw ae;
    }

    public final TestObserver<T> assertComplete() {
        long c = this.completions;
        if (c == 0L) {
            this.fail("Not completed");
        } else if (c > 1L) {
            this.fail("Multiple completions: " + c);
        }
        return this;
    }

    public final TestObserver<T> assertNotComplete() {
        long c = this.completions;
        if (c == 1L) {
            this.fail("Completed!");
        } else if (c > 1L) {
            this.fail("Multiple completions: " + c);
        }
        return this;
    }

    public final TestObserver<T> assertNoErrors() {
        int s = this.errors.size();
        if (s != 0) {
            this.fail("Error(s) present: " + this.errors);
        }
        return this;
    }

    public final TestObserver<T> assertError(Throwable error) {
        int s = this.errors.size();
        if (s == 0) {
            this.fail("No errors");
        }
        if (this.errors.contains(error)) {
            if (s != 1) {
                this.fail("Error present but other errors as well");
            }
        } else {
            this.fail("Error not present");
        }
        return this;
    }

    public final TestObserver<T> assertError(Class<? extends Throwable> errorClass) {
        int s = this.errors.size();
        if (s == 0) {
            this.fail("No errors");
        }
        boolean found = false;
        for (Throwable e : this.errors) {
            if (!errorClass.isInstance(e)) continue;
            found = true;
            break;
        }
        if (found) {
            if (s != 1) {
                this.fail("Error present but other errors as well");
            }
        } else {
            this.fail("Error not present");
        }
        return this;
    }

    public final TestObserver<T> assertValue(T value) {
        T v;
        int s = this.values.size();
        if (s != 1) {
            this.fail("Expected: " + TestObserver.valueAndClass(value) + ", Actual: " + this.values);
        }
        if (!ObjectHelper.equals(value, v = this.values.get(0))) {
            this.fail("Expected: " + TestObserver.valueAndClass(value) + ", Actual: " + TestObserver.valueAndClass(v));
        }
        return this;
    }

    static String valueAndClass(Object o) {
        if (o != null) {
            return o + " (class: " + o.getClass().getSimpleName() + ")";
        }
        return "null";
    }

    public final TestObserver<T> assertValueCount(int count) {
        int s = this.values.size();
        if (s != count) {
            this.fail("Value counts differ; Expected: " + count + ", Actual: " + s);
        }
        return this;
    }

    public final TestObserver<T> assertNoValues() {
        return this.assertValueCount(0);
    }

    public final TestObserver<T> assertValues(T ... values) {
        int s = this.values.size();
        if (s != values.length) {
            this.fail("Value count differs; Expected: " + values.length + " " + Arrays.toString(values) + ", Actual: " + s + " " + this.values);
        }
        for (int i = 0; i < s; ++i) {
            T u = values[i];
            T v = this.values.get(i);
            if (ObjectHelper.equals(u, v)) continue;
            this.fail("Values at position " + i + " differ; Expected: " + TestObserver.valueAndClass(u) + ", Actual: " + TestObserver.valueAndClass(v));
        }
        return this;
    }

    public final TestObserver<T> assertValueSet(Collection<? extends T> expected) {
        int s = this.values.size();
        if (s != expected.size()) {
            this.fail("Value count differs; Expected: " + expected.size() + " " + expected + ", Actual: " + s + " " + this.values);
        }
        for (T v : this.values) {
            if (expected.contains(v)) continue;
            this.fail("Value not in the expected collection: " + TestObserver.valueAndClass(v));
        }
        return this;
    }

    public final TestObserver<T> assertValueSequence(Iterable<? extends T> sequence) {
        int i = 0;
        Iterator<T> vit = this.values.iterator();
        Iterator<T> it = sequence.iterator();
        boolean itNext = false;
        boolean vitNext = false;
        while ((itNext = it.hasNext()) && (vitNext = vit.hasNext())) {
            T v = it.next();
            T u = vit.next();
            if (!ObjectHelper.equals(u, v)) {
                this.fail("Values at position " + i + " differ; Expected: " + TestObserver.valueAndClass(u) + ", Actual: " + TestObserver.valueAndClass(v));
            }
            ++i;
        }
        if (itNext && !vitNext) {
            this.fail("More values received than expected (" + i + ")");
        }
        if (!itNext && !vitNext) {
            this.fail("Fever values received than expected (" + i + ")");
        }
        return this;
    }

    public final TestObserver<T> assertTerminated() {
        int s;
        long c;
        if (this.done.getCount() != 0L) {
            this.fail("Subscriber still running!");
        }
        if ((c = this.completions) > 1L) {
            this.fail("Terminated with multiple completions: " + c);
        }
        if ((s = this.errors.size()) > 1) {
            this.fail("Terminated with multiple errors: " + s);
        }
        if (c != 0L && s != 0) {
            this.fail("Terminated with multiple completions and errors: " + c);
        }
        return this;
    }

    public final TestObserver<T> assertNotTerminated() {
        if (this.done.getCount() == 0L) {
            this.fail("Subscriber terminated!");
        }
        return this;
    }

    public final TestObserver<T> assertSubscribed() {
        if (this.subscription.get() == null) {
            this.fail("Not subscribed!");
        }
        return this;
    }

    public final TestObserver<T> assertNotSubscribed() {
        if (this.subscription.get() != null) {
            this.fail("Subscribed!");
        } else if (!this.errors.isEmpty()) {
            this.fail("Not subscribed but errors found");
        }
        return this;
    }

    public final boolean awaitTerminalEvent() {
        try {
            this.await();
            return true;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final boolean awaitTerminalEvent(long duration, TimeUnit unit) {
        try {
            return this.await(duration, unit);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final TestObserver<T> assertErrorMessage(String message) {
        int s = this.errors.size();
        if (s == 0) {
            this.fail("No errors");
        } else if (s == 1) {
            Throwable e = this.errors.get(0);
            if (e == null) {
                this.fail("Error is null");
                return this;
            }
            String errorMessage = e.getMessage();
            if (!ObjectHelper.equals(message, errorMessage)) {
                this.fail("Error message differs; Expected: " + message + ", Actual: " + errorMessage);
            }
        } else {
            this.fail("Multiple errors");
        }
        return this;
    }

    public final List<List<Object>> getEvents() {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        result.add(this.values());
        result.add(this.errors());
        ArrayList completeList = new ArrayList();
        for (long i = 0L; i < this.completions; ++i) {
            completeList.add(Notification.createOnComplete());
        }
        result.add(completeList);
        return result;
    }

    final TestObserver<T> setInitialFusionMode(int mode) {
        this.initialFusionMode = mode;
        return this;
    }

    final TestObserver<T> assertFusionMode(int mode) {
        int m = this.establishedFusionMode;
        if (m != mode) {
            if (this.qs != null) {
                throw new AssertionError((Object)("Fusion mode different. Expected: " + this.fusionModeToString(mode) + ", actual: " + this.fusionModeToString(m)));
            }
            throw new AssertionError((Object)"Upstream is not fuseable");
        }
        return this;
    }

    private String fusionModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "SYNC";
            }
            case 2: {
                return "ASYNC";
            }
        }
        return "Unknown(" + mode + ")";
    }

    final TestObserver<T> assertFuseable() {
        if (this.qs == null) {
            throw new AssertionError((Object)"Upstream is not fuseable.");
        }
        return this;
    }

    final TestObserver<T> assertNotFuseable() {
        if (this.qs != null) {
            throw new AssertionError((Object)"Upstream is fuseable.");
        }
        return this;
    }

    public final TestObserver<T> assertOf(Consumer<? super TestObserver<T>> check) {
        try {
            check.accept(this);
        }
        catch (Throwable ex) {
            throw Exceptions.propagate(ex);
        }
        return this;
    }

    public final TestObserver<T> assertResult(T ... values) {
        return this.assertValues(values).assertNoErrors().assertComplete();
    }

    public final TestObserver<T> assertFailure(Class<? extends Throwable> error, T ... values) {
        return this.assertValues(values).assertError(error).assertNotComplete();
    }

    public final TestObserver<T> assertFailureAndMessage(Class<? extends Throwable> error, String message, T ... values) {
        return this.assertValues(values).assertError(error).assertErrorMessage(message).assertNotComplete();
    }

    private static enum EmptyObserver implements Observer<Object>
    {
        INSTANCE;


        @Override
        public void onSubscribe(Disposable d) {
        }

        @Override
        public void onNext(Object t) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onComplete() {
        }
    }
}

