/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observers;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public final class SafeObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    Disposable s;
    boolean done;

    public SafeObserver(Observer<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (this.done) {
            return;
        }
        if (DisposableHelper.validate(this.s, s)) {
            this.s = s;
            try {
                this.actual.onSubscribe(this);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.done = true;
                try {
                    s.dispose();
                }
                catch (Throwable e1) {
                    Exceptions.throwIfFatal(e1);
                    RxJavaPlugins.onError(e1);
                }
                RxJavaPlugins.onError(e);
            }
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (t == null) {
            this.onError(new NullPointerException());
            return;
        }
        if (this.s == null) {
            this.onError(null);
            return;
        }
        try {
            this.actual.onNext(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            this.onError(e);
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.s == null) {
            CompositeException t2 = new CompositeException(t, new NullPointerException("Subscription not set!"));
            try {
                this.actual.onSubscribe(EmptyDisposable.INSTANCE);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                t2.suppress(e);
                RxJavaPlugins.onError(t2);
                return;
            }
            try {
                this.actual.onError(t2);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                t2.suppress(e);
                RxJavaPlugins.onError(t2);
            }
            return;
        }
        CompositeException t2 = null;
        if (t == null) {
            t = new NullPointerException();
        }
        try {
            this.s.dispose();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            t2 = new CompositeException(e, t);
        }
        try {
            if (t2 != null) {
                this.actual.onError(t2);
            } else {
                this.actual.onError(t);
            }
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            if (t2 == null) {
                RxJavaPlugins.onError(e);
            }
            t2.suppress(e);
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        if (this.s == null) {
            this.onError(null);
            return;
        }
        this.done = true;
        try {
            this.s.dispose();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.actual.onError(e);
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                RxJavaPlugins.onError(new CompositeException(e1, e));
            }
            return;
        }
        try {
            this.actual.onComplete();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
    }
}

