/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.util.Pow2;
import java.util.Arrays;

public final class OpenHashSet<T> {
    private static final int INT_PHI = -1640531527;
    final float loadFactor;
    int mask;
    int size;
    int maxSize;
    T[] keys;

    public OpenHashSet() {
        this(16, 0.75f);
    }

    public OpenHashSet(int capacity) {
        this(capacity, 0.75f);
    }

    public OpenHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        int c = Pow2.roundToPowerOfTwo(capacity);
        this.mask = c - 1;
        this.maxSize = (int)(loadFactor * (float)c);
        this.keys = new Object[c];
    }

    public boolean add(T value) {
        T[] a = this.keys;
        int m = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m;
        T curr = a[pos];
        if (curr != null) {
            if (curr.equals(value)) {
                return false;
            }
            while ((curr = a[pos = pos + 1 & m]) != null) {
                if (!curr.equals(value)) continue;
                return false;
            }
        }
        a[pos] = value;
        if (++this.size >= this.maxSize) {
            this.rehash();
        }
        return true;
    }

    public boolean remove(T value) {
        T[] a = this.keys;
        int m = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m;
        T curr = a[pos];
        if (curr == null) {
            return false;
        }
        if (curr.equals(value)) {
            return this.removeEntry(pos, a, m);
        }
        do {
            if ((curr = a[pos = pos + 1 & m]) != null) continue;
            return false;
        } while (!curr.equals(value));
        return this.removeEntry(pos, a, m);
    }

    boolean removeEntry(int pos, T[] a, int m) {
        --this.size;
        while (true) {
            T curr;
            int last = pos;
            pos = pos + 1 & m;
            while (true) {
                if ((curr = a[pos]) == null) {
                    a[last] = null;
                    return true;
                }
                int slot = OpenHashSet.mix(curr.hashCode()) & m;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & m;
            }
            a[last] = curr;
        }
    }

    public void clear(Consumer<? super T> clearAction) throws Exception {
        Object[] a;
        if (this.size == 0) {
            return;
        }
        for (T t : a = this.keys) {
            if (t == null) continue;
            clearAction.accept(t);
        }
        Arrays.fill(a, null);
        this.size = 0;
    }

    void rehash() {
        T[] a = this.keys;
        int i = a.length;
        int newCap = i << 1;
        int m = newCap - 1;
        Object[] b = new Object[newCap];
        int j = this.size;
        while (j-- != 0) {
            while (a[--i] == null) {
            }
            int pos = OpenHashSet.mix(a[i].hashCode()) & m;
            if (b[pos] != null) {
                while (b[pos = pos + 1 & m] != null) {
                }
            }
            b[pos] = a[i];
        }
        this.mask = m;
        this.maxSize = (int)((float)newCap * this.loadFactor);
        this.keys = b;
    }

    static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public void forEach(Consumer<? super T> consumer) throws Exception {
        for (T k : this.keys) {
            if (k == null) continue;
            consumer.accept(k);
        }
    }

    public Throwable forEachSuppress(Consumer<? super T> consumer) {
        CompositeException ex = null;
        int count = 0;
        for (T k : this.keys) {
            if (k == null) continue;
            try {
                consumer.accept(k);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                if (ex == null) {
                    ex = new CompositeException();
                }
                ++count;
                ex.suppress(e);
            }
        }
        if (count == 1) {
            return ex.getExceptions().get(0);
        }
        return ex;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object[] keys() {
        return this.keys;
    }

    public int size() {
        return this.size;
    }
}

