/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import java.util.concurrent.CountDownLatch;

public abstract class BlockingSingleObserver<T>
extends CountDownLatch
implements Observer<T>,
Disposable {
    T value;
    Throwable error;
    Disposable d;
    volatile boolean cancelled;

    public BlockingSingleObserver() {
        super(1);
    }

    @Override
    public final void onSubscribe(Disposable d) {
        this.d = d;
        if (this.cancelled) {
            d.dispose();
        }
    }

    @Override
    public final void onComplete() {
        this.countDown();
    }

    @Override
    public final void dispose() {
        this.cancelled = true;
        Disposable d = this.d;
        if (d != null) {
            d.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.cancelled;
    }

    public final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                throw Exceptions.propagate(ex);
            }
        }
        if ((e = this.error) != null) {
            throw Exceptions.propagate(e);
        }
        return this.value;
    }
}

