/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.flowable;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class BlockingSingleSubscriber<T>
extends CountDownLatch
implements Subscriber<T>,
Disposable {
    T value;
    Throwable error;
    Subscription s;
    volatile boolean cancelled;

    public BlockingSingleSubscriber() {
        super(1);
    }

    public final void onSubscribe(Subscription s) {
        this.s = s;
        if (!this.cancelled) {
            s.request(Long.MAX_VALUE);
            if (this.cancelled) {
                s.cancel();
            }
        }
    }

    public final void onComplete() {
        this.countDown();
    }

    @Override
    public final void dispose() {
        this.cancelled = true;
        Subscription s = this.s;
        if (s != null) {
            s.cancel();
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.cancelled;
    }

    public final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                throw Exceptions.propagate(ex);
            }
        }
        if ((e = this.error) != null) {
            throw Exceptions.propagate(e);
        }
        return this.value;
    }
}

