/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ObservableFromFuture<T>
extends Observable<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public ObservableFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeActual(Observer<? super T> s) {
        Disposable d = Disposables.empty();
        s.onSubscribe(d);
        if (!d.isDisposed()) {
            T v;
            try {
                v = this.unit != null ? this.future.get(this.timeout, this.unit) : this.future.get();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (!d.isDisposed()) {
                    s.onError(ex);
                }
                return;
            }
            finally {
                this.future.cancel(true);
            }
            if (!d.isDisposed()) {
                if (v != null) {
                    s.onNext(v);
                    s.onComplete();
                } else {
                    s.onError(new NullPointerException("Future returned null"));
                }
            }
        }
    }
}

